package com.northpool.resources.datatable.db;

import java.io.Serializable;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.ArrayUtils;

import com.northpool.commons.reflect.Bean;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.command.Constants.OPERATION;
import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datatable.IField;
import com.northpool.resources.datatable.IPersistDao;
import com.northpool.resources.datatable.Scroll;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatablebuilder.db.IDBTableBuilder;
import com.northpool.resources.sql.SQLQueryEngine;
import com.northpool.resources.sql.jdbc.SQLGenericDaoImpl;
import com.northpool.resources.sql.jdbc.SQLTransformer;
import com.northpool.resources.sql.jdbc.UpdateDataScroll;
import com.northpool.resources.type.Type;
import com.northpool.resources.sql.SQLParameter;

@Deprecated
public class DBPersistDaoImpl<T, PK> extends SQLGenericDaoImpl implements IPersistDao<T, PK> {

	protected DBTable dbTable;
	
	
	public DBPersistDaoImpl(DbDataSource dbDataSource,DBTable dbTable) throws Exception {
		super(dbDataSource);
		this.dbTable = dbTable;
	}
	
	protected void checkWriteable(){
		if(dbTable.getIsView()){
			throw new RuntimeException(dbTable.mark() + "为试图,不能执行写操作");
		}
	}

	/*protected String[] fieldToFieldInDB(String[] fields){
		
	}*/
	
	
	
	@Override
	public void insertManyDataArray(final List<Object[]> list,final String[] fields,final Integer batchSize) throws DataAccessException{
		String idFieldName = this.dbTable.getIdField();
		
		if(ArrayUtils.indexOf(fields, idFieldName) == -1){
			//没有在选择字段中寻找到主键，则需要报错
			throw new DataAccessException(String.format("字段中缺少主键%s",idFieldName));
		}
		/*int size = this.dbTable.fields().length;
		String[] fieldsInDB = new String[size];
        String[] fields = new String[size];
        Type[] types = new Type[size];
        for(int index = 0 ; index < size ; index ++){
            IField field = this.dbTable.fields()[index];
            fieldsInDB[index] = field.getOriginFieldName();
            fields[index] = field.getFieldName();
            types[index] = field.getType();
        }*/
		
		//List<String> fieldArr = new ArrayList<String>();
		String[] fieldsInDB = new String[fields.length];
		Type[] types = new Type[fields.length];
        Map<String,IField> mapField = dbTable.getFieldsMap();
        for(int i = 0 ; i < fields.length ; i++){
            String field = fields[i];
            IField dbField = mapField.get(field);
            if(dbField == null){
                throw new RuntimeException(String.format("表:%s中没有找到字段", dbTable.mark(),dbField));
            }
            fieldsInDB[i] = dbField.getOriginFieldName();
            types[i] = dbField.getType();
            
        }
      //  return fieldArr.toArray(new String[fieldArr.size()]);
		
		//String[] fieldsInDB = this.fieldToFieldInDB(fields);
		
		
		String sql = this.dialect.createInsertSQL(((IDBTableBuilder)this.dbTable.getTableBuilder()).getSchema(),this.dbTable.getTablename(), fieldsInDB);
	
		
		this.doBatchExecuteSql(sql, list,types, batchSize);
		
	}
	
	

	

	



	@Override
	public void remove(QueryFilter filter) {
		// TODO Auto-generated method stub
		
	}



	

	@Override
	public List<Map<String, ?>> queryForMap(QueryFilter filter) {
		return this.queryForMap(filter, null);
	}

	@Override
	public List<Object[]> queryForArray(QueryFilter filter, Integer fetchSize) {
		// TODO Auto-generated method stub
		SQLQueryEngine engine = null;
		try {
			 engine = SQLQueryEngine.create(this.dbTable, filter);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		SQLParameter parameter = engine.toNativeSQL();
		List<Object[]> i = this.queryBySql(parameter.getSql(), parameter.getValues(),parameter.getTypes(), parameter.getReturnTypeMap(),filter.getStart(),filter.getEnd(),fetchSize,SQLTransformer.ARRAY);
		return i;
	}

	public void insertManyDataMap(final List<Map<String, ?>> list,final Integer batchSize) throws DataAccessException {
	    this.insertManyDataMap(list,false,batchSize);
	}
	
	
	@Override
	public void insertManyDataMap(final List<Map<String, ?>> list,final Boolean insertPK,final Integer batchSize) throws DataAccessException {
		// TODO Auto-generated method stub
	    int size = this.dbTable.fields().length;
	    /*if(insertPK){
	        size = this.dbTable.fields().length;
	    }else{
	        size = this.dbTable.fields().length - 1;
	    }
		String[] fieldsInDB = new String[size];
		String[] fields = new String[size];
		Type[] types = new Type[size];*/
	    ArrayList<String> fieldsInDBArr = new ArrayList<>();
	    ArrayList<String> fieldsArr = new ArrayList<>();
	    ArrayList<Type> typesArr = new ArrayList<>();
		for(int index = 0 ; index < size ; index ++){
			IField field = this.dbTable.fields()[index];
			if(field.isPK() && !insertPK){
			    continue;
			}
			fieldsInDBArr.add(field.getOriginFieldName());
			fieldsArr.add(field.getFieldName());
			typesArr.add(field.getType());
			
		}
		String[] fieldsInDB = fieldsInDBArr.toArray(new String[fieldsInDBArr.size()]);
        String[] fields = fieldsArr.toArray(new String[fieldsArr.size()]);
        Type[] types = typesArr.toArray(new Type[typesArr.size()]);
		
		String sql = this.dialect.createInsertSQL(((IDBTableBuilder)this.dbTable.getTableBuilder()).getSchema(),this.dbTable.getTablename(), fieldsInDB);
		UpdateDataScroll scroll = new UpdateDataScroll(){
			Iterator<Map<String, ?>> iterator = list.iterator();
			@Override
			public boolean hasNext() {
				// TODO Auto-generated method stub
				return iterator.hasNext();
			}

			@Override
			public Object[] next() {
				Map<String,?> data = iterator.next();
				Object[] values = new Object[fields.length];
				// TODO Auto-generated method stub
				for(int i = 0 ; i < fields.length ; i ++){
					String field = fields[i];
					Object value = data.get(field);
					values[i] = value;
				}
				return values;
			}

			@Override
			public int size() {
				// TODO Auto-generated method stub
				return list.size();
			}
			
		};
		this.doBatchExecuteSql(sql,types, scroll, batchSize);
		return;
		
	}

	@Override
	public List<Map<String, ?>> queryForMap(QueryFilter filter, Integer fetchSize) {
		// TODO Auto-generated method stub
		SQLQueryEngine engine = null;
		try {
			 engine = SQLQueryEngine.create(this.dbTable, filter);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		SQLParameter parameter = engine.toNativeSQL();
		List<Map<String, ?>> i = this.queryBySql(parameter.getSql(), parameter.getValues(),parameter.getTypes(), parameter.getReturnTypeMap(),filter.getStart(),filter.getEnd(),fetchSize,SQLTransformer.MAP);
		return i;
	}

  
    @Override
    public Map<String,?> getForMap(PK pk) {
        // TODO Auto-generated method stub
        String idFiled = dbTable.getIdField();
        QueryFilter filter = new QueryFilter();
        filter.addFilter(idFiled, OPERATION.EQ,pk);
        List<Map<String, ?>> ii = this.queryForMap(filter);
        if(ii.isEmpty()){
            return null;
        }
        return ii.get(0);
    }

   

 
    @Override
    public Long count(QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

   
    
   
   

    
    @Override
    public List<Object[]> queryForArray(QueryFilter filter) throws DataAccessException {
        // TODO Auto-generated method stub
        return this.queryForArray(filter, null);
    }

   
   

   
    @Override
    public Scroll<Map<String, ?>> scrollForMap(QueryFilter filter) throws DataAccessException {
        

        return this.scrollForMap(filter, null);
    }

    
    @Override
    public Scroll<Object[]> scrollForArray(QueryFilter filter) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

    
    @Override
    public Scroll<T> scroll(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IQueryTable#scrollForMap(com.northpool.resources.command.QueryFilter, java.lang.Integer)
     */
    @Override
    public Scroll<Map<String, ?>> scrollForMap(QueryFilter filter, Integer fetchSize) throws DataAccessException {
        SQLQueryEngine engine = null;
        try {
             engine = SQLQueryEngine.create(this.dbTable, filter);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        Scroll<Map<String, ?>> s = this.scrollBySql(parameter.getSql(), parameter.getValues(), parameter.getTypes(),parameter.getReturnTypeMap(),filter.getStart(),filter.getEnd(),fetchSize,SQLTransformer.MAP);
        return s;
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IQueryTable#scrollForArray(com.northpool.resources.command.QueryFilter, java.lang.Integer)
     */
    @Override
    public Scroll<Object[]> scrollForArray(QueryFilter filter, Integer fetchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        SQLQueryEngine engine = null;
        try {
             engine = SQLQueryEngine.create(this.dbTable, filter);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        Scroll<Object[]> s = this.scrollBySql(parameter.getSql(), parameter.getValues(), parameter.getTypes(),parameter.getReturnTypeMap(),filter.getStart(),filter.getEnd(),fetchSize,SQLTransformer.ARRAY);
        return s;
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#insert(java.lang.Object)
     */
    

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#saveOrUpdate(java.lang.Object)
     */
    @Override
    public void saveOrUpdate(T t) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#removeAll()
     */
    @Override
    public void removeAll() throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#insertMany(java.util.List)
     */
    @Override
    public void insertMany(List<T> list) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#insertManyDataArray(java.util.List, java.lang.String[])
     */
    @Override
    public void insertManyDataArray(List<Object[]> list, String[] fields) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#insertManyDataMap(java.util.List)
     */
    @Override
    public void insertManyDataMap(List<Map<String, ?>> list) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#insertMany(java.util.List, java.lang.Integer)
     */
    @Override
    public void insertMany(List<T> list, Integer batchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#update(java.lang.Object)
     */
    @Override
    public void update(T t) throws DataAccessException {
        // TODO Auto-generated method stub
        String idFieldName = this.dbTable.getIdField();
        String idFieldNameInDB = this.dbTable.getFieldsMap().get(idFieldName).getOriginFieldName();
        //String sql = this.dialect.createUpdateSQL(tableName, fields, where);
        
        int size = this.dbTable.fields().length;
        
        String[] fieldsInDB = new String[size ];
        String[] fields = new String[size - 1];
        Type[] types = new Type[size];
        Object[] args = new Object[size];
        int i = 0;
        for(int index = 0 ; index < this.dbTable.fieldSize() ; index ++){
            IField field = this.dbTable.fields()[index];
            if(field.isPK()){
                continue;
            }  
            fieldsInDB[i] = field.getOriginFieldName();
            fields[i] = field.getFieldName();
            types[i] = field.getType();
            args[i] = Bean.getObjectValueByFieldName(t, field.getFieldName());
            i++;
        }
        
        types[size - 1] = this.dbTable.getTableBuilder().getPKColumnInfo().getType();
        args[size - 1] = Bean.getObjectValueByFieldName(t,idFieldName);
        
        String sql = this.dialect.createUpdateSQL( ((IDBTableBuilder)this.dbTable.getTableBuilder()).getSchema(),this.dbTable.getTablename(), fields, idFieldNameInDB + " = ?");
        
        
        
        this.doExecuteSql(sql, args,types);
        
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#updateMap(java.util.Map)
     */
   

    public void insert(T t) throws DataAccessException {
        this.insert(t, false);
    }
    
    
    
    
    @Override
    public void insert(T t,Boolean insertNull) throws DataAccessException {
        // TODO Auto-generated method stub
        int size = this.dbTable.fields().length;
        String[] fieldsInDB = new String[size];
        String[] fields = new String[size];
        Type[] types = new Type[size];
        for(int index = 0 ; index < size ; index ++){
            IField field = this.dbTable.fields()[index];
            fieldsInDB[index] = field.getOriginFieldName();
            fields[index] = field.getFieldName();
            types[index] = field.getType();
        }
        Object[] args = null;
        if(insertNull){
            args = new Object[size];
           
            for(int i = 0 ; i < fieldsInDB.length ; i ++){
                String fieldInDB = fieldsInDB[i];
                String fieldName = fields[i];
                args[i] = Bean.getObjectValueByFieldName(t, fieldName);
            }
        }else{
            List<String> newFieldInDb = new ArrayList<>(size);
            List<Object> argsList = new ArrayList<>(size);
            List<Type> typeList = new ArrayList<>(size);
            for(int i = 0 ; i < fieldsInDB.length ; i ++){
                String fieldInDB = fieldsInDB[i];
                String fieldName = fields[i];
                Object o = Bean.getObjectValueByFieldName(t, fieldName);
                if(o != null){
                    newFieldInDb.add(fieldInDB);
                    argsList.add(o);
                    typeList.add(this.dbTable.getFieldsInTableMap().get(fieldInDB).getType());
                }
                
            }
            fieldsInDB = newFieldInDb.toArray(new String[newFieldInDb.size()]);
            args = argsList.toArray(new Object[argsList.size()]);
            types = typeList.toArray(new Type[typeList.size()]);
        }
        
        
        String sql = this.dialect.createInsertSQL(((IDBTableBuilder)this.dbTable.getTableBuilder()).getSchema(),this.dbTable.getTablename(), fieldsInDB);
        
        this.doExecuteSql(sql, args,types);
        
        return;
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#updateMany(java.util.Map, com.northpool.resources.command.QueryFilter)
     */
    @Override
    public void updateMany(Map<String, ?> m, QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#updateMany(java.util.Map, com.northpool.resources.command.QueryFilter, java.lang.Integer)
     */
    @Override
    public void updateMany(Map<String, ?> m, QueryFilter queryFilter, Integer batchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#remove(java.io.Serializable)
     */
    @Override
    public void remove(PK pk) throws DataAccessException {
        // TODO Auto-generated method stub
        String idFieldName = this.dbTable.getIdField();
        IField idField = this.dbTable.getFieldsMap().get(idFieldName);
        String idFieldNameInDB = idField.getOriginFieldName();
        String sql = this.dialect.createDeleteSQL(((IDBTableBuilder)this.dbTable.getTableBuilder()).getSchema(),this.dbTable.getTablename(), idFieldNameInDB + " = ?");
        this.doExecuteSql(sql, new Object[]{pk},new Type[]{idField.getType()});
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#updateMap(java.io.Serializable, java.util.Map)
     */
    @Override
    public void updateMap(PK pk, Map<String, ?> m) throws DataAccessException {
        // TODO Auto-generated method stub
        String idFieldName = this.dbTable.getIdField();
        String idFieldNameInDB = this.dbTable.getFieldsMap().get(idFieldName).getOriginFieldName();
        //String sql = this.dialect.createUpdateSQL(tableName, fields, where);
        
        int size = this.dbTable.fields().length;
        
        String[] fieldsInDB = new String[size ];
        String[] fields = new String[size - 1];
        Type[] types = new Type[size];
        Object[] args = new Object[size];
        int i = 0;
        for(int index = 0 ; index < this.dbTable.fieldSize() ; index ++){
            IField field = this.dbTable.fields()[index];
            if(field.isPK()){
                continue;
            }  
            fieldsInDB[i] = field.getOriginFieldName();
            fields[i] = field.getFieldName();
            types[i] = field.getType();
            args[i] = Bean.getObjectValueByFieldName(m, field.getFieldName());
            i++;
        }
        
        types[size - 1] = this.dbTable.getTableBuilder().getPKColumnInfo().getType();
        args[size - 1] = pk;
        
        String sql = this.dialect.createUpdateSQL( ((IDBTableBuilder)this.dbTable.getTableBuilder()).getSchema(),this.dbTable.getTablename(), fields, idFieldNameInDB + " = ?");
        
        
        
        this.doExecuteSql(sql, args,types);
        
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IPersistDao#scrollId(com.northpool.resources.command.QueryFilter, java.lang.Integer)
     */
    @Override
    public Scroll<Object> scrollId(QueryFilter filter, Integer fetchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        //SQLTransformer<Object> ID = new IDSQLTransformer(this.dbTable.);
        filter.setOutputFieldNames(this.dbTable.getIdField());
        SQLQueryEngine engine = null;
        try {
             engine = SQLQueryEngine.create(this.dbTable, filter);
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        
        return this.scrollBySql(parameter.getSql(), parameter.getValues(), parameter.getTypes(),parameter.getReturnTypeMap(),filter.getStart(),filter.getEnd(),fetchSize,SQLTransformer.ONEFILED);
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IQueryTable#get(java.lang.Object)
     */
    @Override
    public T get(PK pk) {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IQueryTable#query(com.northpool.resources.command.QueryFilter)
     */
    @Override
    public List<T> query(QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IQueryTable#query(com.northpool.resources.command.QueryFilter, java.lang.Integer)
     */
    @Override
    public List<T> query(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#updateMany(java.lang.Object, com.northpool.resources.command.QueryFilter)
     */
    @Override
    public void updateMany(Object o, QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IQueryTable#queryArray(com.northpool.resources.command.QueryFilter, java.lang.Integer)
     */
    @Override
    public List<Object[]> queryArray(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IQueryTable#scrollArray(com.northpool.resources.command.QueryFilter, java.lang.Integer)
     */
    @Override
    public Scroll<Object[]> scrollArray(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        return null;
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IEditTable#insertMany(java.util.List, java.lang.String[], java.lang.Integer)
     */
    @Override
    public void insertMany(List<Object[]> list, String[] fields, Integer batchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.IQueryTable#scroll(com.northpool.resources.command.QueryFilter)
     */
    @Override
    public Scroll<T> scroll(QueryFilter queryFilter) throws DataAccessException {
        // TODO Auto-generated method stub
        return this.scroll(queryFilter, null);
    }

   

}
