package com.northpool.resources.datatable.db;


import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datatable.AbstractTable;
import com.northpool.resources.datatable.IPersistDao;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.dao.IMapDAO;
import com.northpool.resources.datatablebuilder.BuilderManager;
import com.northpool.resources.datatablebuilder.ITableBuilder;
import com.northpool.resources.datatablebuilder.db.IDBTableBuilder;






 
public class DBTable extends AbstractTable implements ITable {
	
	
	
    
	
	public DbDataSource getDbDataSource() {
		return (DbDataSource) dataSource;
	}

	public void setDbDataSource(DbDataSource dbDataSource) {
		this.dataSource = dbDataSource;
	}
	@Override
	@Deprecated
	public <T,PK> IPersistDao<T,PK> persistDao() throws Exception{
		
		DBPersistDaoImpl<T,PK> dao = new DBPersistDaoImpl<T,PK>((DbDataSource)this.dataSource,this);
		
		return dao;
	}
	
	@Override
	public void reload() throws Exception {
		// TODO Auto-generated method stub
		IDBTableBuilder idbTableBuilder = (IDBTableBuilder) this.builder;
		BuilderManager.getInstance().remove(this.dataSource, tablename);
		BuilderManager.getInstance().remove(this.dataSource, idbTableBuilder.getSchema() + "." + tablename);
		ITableBuilder tableBuilder = BuilderManager.getInstance().getTableBuilder(this.dataSource, this.tablename,null);
		this.builderToTable((IDBTableBuilder)tableBuilder, this.fieldEncoder,this.selectColumns);
	}

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.ITable#mapDao()
     */
    @Override
    public <PK> IMapDAO<PK> mapDao() {
        // TODO Auto-generated method stub
        IMapDAO<PK> dao = new DBMapDAOImpl<PK>(this.getDbDataSource(),this);
        return dao;
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.datatable.ITable#dao()
     */
    
    /*public <T, PK> IDAO <T, PK> dao() {
        // TODO Auto-generated method stub
        IDAO<Map<String,?>,T> dao = new DBMapDAOImpl<T>(this.getDbDataSource(),this);
        
        
        return ;
    }*/

	

	

	
	

	
}

