package com.northpool.resources.datatablebuilder.db;

import com.northpool.resources.Constants.DATA_BASE_TYPE;
import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datatablebuilder.ATableBuilder;
import com.northpool.resources.datatablebuilder.IColumn;
import com.northpool.resources.datatablebuilder.db.column.KingbaseColumn;
import com.northpool.resources.datatablebuilder.db.index.Index;
import com.northpool.resources.dialect.db.SQLDialect;
import com.northpool.resources.sql.jdbc.SQLTransformer;
import com.northpool.resources.type.Type;
import com.northpool.resources.type.TypePGGeometry;
import com.northpool.spatial.Constants.GEO_TYPE;
import com.northpool.spatial.geofeature.GeoBuffer;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@ATableBuilder(name = "kingbase", type = DATA_SOURCE_TYPE.kingbase)

public class KingbaseTableBuilder extends AbstractDBTableBuilder implements IDBTableBuilder {
 
	
	
	
	protected final static String  DEFAULT_PG_SCHEMA = "public";
	
	@Override
	protected DATA_BASE_TYPE processDataBaseType() {
		// TODO Auto-generated method stub
		return DATA_BASE_TYPE.kingbase;
	}

	@Override
	protected void processTableNameAndSchema(String tableName, String schema,Boolean isCaseSensitive) {
		
		if (tableName.contains(".")){//若表名含有. 则按.进行分割，分割为schema 和 tableName
			String[] arr = tableName.split("\\.");
			tableName = arr[1];
			schema = arr[0];
		}
		if(schema == null){
			schema = DEFAULT_PG_SCHEMA;
		}
		this.tableName = tableName;
		this.schema = schema;
		if(isCaseSensitive){
            tableName = tableName.toLowerCase();
            schema = schema.toLowerCase();
        }
	}
 
	

	@Override
	protected String getRemarks(ResultSet columns) throws SQLException {
		return columns.getString(REMARKS);
	}

	@Override
	protected ResultSet getColumns(DatabaseMetaData dbmd, String tableName, String schema) throws SQLException {
		ResultSet columns = dbmd.getColumns(this.cataLog, this.schema, this.tableName.replace("\"", ""), null);
		return columns;
	}

	@Override
	protected IColumn createColumn(String columnName, Integer columnSize, Integer digits,
			String columnTypeName, Boolean nullable, Boolean withDefault, String remarks) {
		KingbaseColumn column = new KingbaseColumn( columnName,  columnSize,  digits,
			 columnTypeName,  nullable,  withDefault,  remarks,(SQLDialect)this.dialect);
		return column;
	}

	//@Override
/*	protected void buildIndexInfo(DatabaseMetaData dbmd) {
		// TODO Auto-generated method stub
		
	}*/

	
	@Override
	protected Object[] getSpatialInfo(String colunmName) throws SQLException{
		String sql = "select srid,type from geometry_columns where f_table_catalog = ? and f_table_schema = ? and f_table_name = ? and f_geometry_column = ?";
		List<Map<String,?>> i  = this.genericDao.queryBySql(sql, new Object[]{this.cataLog,this.schema,this.tableName,colunmName}, null,null,null,null,null,SQLTransformer.MAP);
		if(i.isEmpty()){
			return null;
		}else{
			Map<String,?> data = i.get(0);
			Integer srid = (Integer)data.get("srid");
			String type = (String)data.get("type");
			GEO_TYPE gtype = GEO_TYPE.GEOMETRY;
			GEO_TYPE[] values = GEO_TYPE.values();
			for(GEO_TYPE geo_type : values){
				if(geo_type.name().equalsIgnoreCase(type)){
					gtype = geo_type;
				}
			}
			return new Object[]{srid,gtype};
		}
		
	}
	
	
	
	

	@Override
	protected CompletableFuture<Void> createSpatialIndex(String colname) {
		// TODO Auto-generated method stub
		String indexName = this.createSpatialIndexName(colname);
		CompletableFuture<Void> promise = CompletableFuture.runAsync(()->{
			logger.info(mark() + "_" + colname + "创建空间索引");
			String sql = "CREATE INDEX " + indexName +  " ON " + this.tableName + "USING gist (" + colname + ");";
			logger.info("execute sql" + sql);
			this.genericDao.doExecuteSql(sql, null,null);
			Index index = new Index();
			index.setName(indexName);
			index.setUnique(false);
			index.isSpatial(true);
			index.setColname(colname);
			this.addToIndexMap(colname, index);
		});
		return promise;
	}

	
	/**
     * 通过第一条记录获得空间属性
     * @param colunmName
     * @return
     * @throws SQLException
     */
	@Override
    protected GeoBuffer getGeoBufferInfoByData(String colunmName) throws SQLException{
        String sql = "select " + colunmName + " from " + this.schema + "." + this.tableName;
        Map<String,Type> typeMap = new HashMap<String,Type>();
        typeMap.put(colunmName, TypePGGeometry.INSTANCE);
        List<Map<String,?>> i = this.genericDao.queryBySql(sql, null, null, null, 0, 1, null,  SQLTransformer.MAP);
        if(i.isEmpty()){
            return null;
        }else{
            Map<String,?> data = i.get(0);
            Object o = data.get(colunmName);
            if(o == null) {
                return null;
            }
            GeoBuffer geo = (GeoBuffer) data.get(colunmName);
            return geo;
        }
    }
	
	

	
	

}
