package com.northpool.resources.datatablebuilder.db;

import com.northpool.resources.Constants.DATA_BASE_TYPE;
import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datatablebuilder.ATableBuilder;
import com.northpool.resources.datatablebuilder.IColumn;
import com.northpool.resources.datatablebuilder.IIndex;
import com.northpool.resources.datatablebuilder.db.column.OracleColumn;
import com.northpool.resources.datatablebuilder.db.index.Index;
import com.northpool.resources.dialect.db.SQLDialect;
import com.northpool.resources.sql.jdbc.SQLTransformer;
import com.northpool.resources.type.Type;
import com.northpool.resources.type.TypeOracleGeometry;
import com.northpool.spatial.Constants;
import com.northpool.spatial.Constants.GEO_TYPE;
import com.northpool.spatial.Constants.SPATIAL_UNIT;
import com.northpool.spatial.geofeature.GeoBuffer;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.*;
import java.util.concurrent.CompletableFuture;

@ATableBuilder(name = "oracle", type = DATA_SOURCE_TYPE.oracle)

public class OracleTableBuilder extends AbstractDBTableBuilder implements IDBTableBuilder {

	//private GeometryOracleConverter goc;

	
	//	goc = new GeometryOracleConverter(this.getConnection());
	

	@Override
	protected DATA_BASE_TYPE processDataBaseType() {
		return DATA_BASE_TYPE.oracle;
	}

	@Override
	protected void processTableNameAndSchema(String tableName, String schema, Boolean isCaseSensitive) {
		
		if (tableName.contains(".")) {// 若表名含有. 则按.进行分割，分割为schema 和 tableName
			String[] arr = tableName.split("\\.");
			tableName = arr[0];
			schema = arr[1];
		}
		DbDataSource dbDataSource = (DbDataSource)this.dataSource;
		if (schema == null) {
			schema = dbDataSource.getUser();
		}
		this.tableName = tableName.toUpperCase();
		this.schema = schema.toUpperCase();
		if (isCaseSensitive) {
            tableName = tableName.toLowerCase();
            schema = schema.toLowerCase();
        }
	}

	@Override
	protected String getRemarks(ResultSet columns) throws SQLException {
		return columns.getString(REMARKS);
	}

	@Override
	protected ResultSet getColumns(DatabaseMetaData dbmd, String tableName, String schema) throws SQLException {
		ResultSet columns = dbmd.getColumns(null, this.schema, this.tableName.replace("\"", ""), null);
		return columns;
	}

	@Override
	protected IColumn createColumn(String columnName, Integer columnSize, Integer digits,
			String columnTypeName, Boolean nullable, Boolean withDefault, String colRemarks) {
		OracleColumn column = new OracleColumn(columnName, columnSize, digits, columnTypeName, nullable,
				withDefault, colRemarks, (SQLDialect)this.dialect);
		return column;
	}
	@Override
	public CompletableFuture<Void> dropIndex(final String indexName) {
		IIndex index = this.indexMap.get(indexName);
		if(index == null){
			DatabaseMetaData dbmd;
			try {
				dbmd = this.dbconn.getMetaData();
				index = this.getIndexInfo(dbmd).get(indexName);
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				throw new RuntimeException(e);
			}
		}
		if(index == null){
			return null;
		}else{
			if(index.getSpatial()){
				String sql = "delete from SDO_GEOM_METADATA_TABLE where SDO_TABLE_NAME = ? and SDO_COLUMN_NAME = ?";
				this.genericDao.doExecuteSql(sql, new Object[]{this.tableName,index.getColname()},null);
			}
		}
		return super.dropIndex(indexName);
		
	}
	 
	
	@Override
	protected CompletableFuture<Void> createSpatialIndex(String colname) {

		Integer srid = this.getSRID(colname);
		
		SPATIAL_UNIT unit = Constants.getSpatialUnitBySRID(srid);
		
		// 插入源数据表
		final StringBuffer inster = new StringBuffer();
		inster.append("INSERT INTO SDO_GEOM_METADATA_TABLE");
		inster.append("(SDO_OWNER,SDO_TABLE_NAME,SDO_COLUMN_NAME,SDO_DIMINFO,SDO_SRID)");
		inster.append(" VALUES  (");
		inster.append(this.schema);
		inster.append(this.tableName);
		inster.append(colname);
		//先这样写，以后再改需要根据srid区别单位是经纬度还是米
		if(unit == SPATIAL_UNIT.degree){
			inster.append("MDSYS.SDO_DIM_ARRAY (").append("MDSYS.SDO_DIM_ELEMENT('X', -180.0, 180.0, 0.005),")
					.append("MDSYS.SDO_DIM_ELEMENT('Y', -90.0,90.0, 0.005))");
		}else{
			inster.append("MDSYS.SDO_DIM_ARRAY (").append("MDSYS.SDO_DIM_ELEMENT('X', -20037508, 20037508, 0.5),")
			.append("MDSYS.SDO_DIM_ELEMENT('Y', -20037508,20037508, 0.5))");
		}
		inster.append(srid);
		inster.append(")");
		this.genericDao.doExecuteSql(inster.toString(), null ,null);
		
		CompletableFuture<Void> promise = CompletableFuture.runAsync(() -> {
			logger.info(mark() + "_" + colname + "创建空间索引");
			String indexName = this.createSpatialIndexName(colname);
			// CREATE INDEX 索引名称 ON 表名 (字段名称) INDEXTYPE IS MDSYS.SPATIAL_INDEX;
			String sql = "CREATE INDEX " + indexName + " ON " + this.tableName + "(" + colname
					+ ") INDEXTYPE IS MDSYS.SPATIAL_INDEX;";
			logger.info("execute sql" + sql);
			this.genericDao.doExecuteSql(sql, null,null);
			Index index = new Index();
			index.setName(indexName);
			index.setUnique(false);
			index.isSpatial(true);
			index.setColname(colname);
			this.addToIndexMap(colname, index);
		});
		return promise;
	}
	
	@Override
	protected Object[] getSpatialInfo(String colunmName) throws SQLException {
		String sql = "SELECT SRID FROM USER_SDO_GEOM_METADATA WHERE TABLE_NAME = ?";
		List<Map<String,?>> i = this.genericDao.queryBySql(sql, new Object[]{colunmName}, null, null, null, null, null,  SQLTransformer.MAP);
		if(i.isEmpty()){
			return null;
		}else{
			Map<String,?> data = i.get(0);
			Integer srid = (Integer) data.get("SRID");
			return new Object[] { srid, GEO_TYPE.GEOMETRY };
		}
		
		
		
		
		/*try (PreparedStatement pstmt = this.dbconn.prepareCall(sql); ResultSet resultSet = pstmt.executeQuery();) {
			if(resultSet.next() == true){
				Integer srid = resultSet.getInt("SRID");
				pstmt.close();
				resultSet.close();
				return new Object[] { srid, GEO_TYPE.GEOMETRY };
			}else{
				pstmt.close();
				resultSet.close();
				return null;
			}
		}*/
	}

	@Override
	protected String getCataLog() throws SQLException {
		return null;
	}

	@Override
	protected void getTableInfo(DatabaseMetaData dbmd, String tableName) throws SQLException {

		try (ResultSet resultSet = dbmd.getTables(null, this.schema, this.tableName,
				new String[] { "TABLE", "VIEW" });) {
			boolean isNull = true;
			while (resultSet.next()) {
				isNull = false;
				String type = resultSet.getString("TABLE_TYPE");
				this.tableRemarks = resultSet.getString("REMARKS");
				if (!"TABLE".equalsIgnoreCase(type)) {
					this.isView = true;
				}
				
			}

			if (isNull) {
				throw new RuntimeException("表/视图" + this.schema + "." + tableName + "不存在");
			}
			resultSet.close();
		}

	}
	
	@Override
	protected void buildColumns(DatabaseMetaData dbmd,String tableName,String schema) throws SQLException{
		
		
//		if(columns.wasNull()){
//			throw new RuntimeException(schema + "." + tableName + "获取列失败");
//		}
//		String[] types = new String[1];
		List<String> tmp = new ArrayList<String>();

		try (ResultSet columns = this.getColumns(dbmd, tableName, schema);) {
			Set<String> colnameSet = new HashSet<String>();
			boolean isNull = true;
			while (columns.next()) {
				isNull = false;
				String columName = columns.getString(COLUMN_NAME);
				colnameSet.add(columName);
				Short columType = columns.getShort(DATA_TYPE);
				Integer columSize = columns.getInt(COLUMN_SIZE);
				Integer digits = 0;
				String columTypeName = columns.getString(TYPE_NAME);
				Boolean nullable = false;
				Boolean withDefault = false;
				
				if ((columType == 3) || (columType == 2)) {
					digits = columns.getInt(DECIMAL_DIGITS);
				}

				if (columns.getInt(NULLABLE) == 1)
					nullable = true;
				else {
					nullable = false;
				}
				withDefault = columns.getString(COLUMN_DEF) != null;
				String colRemarks = this.getRemarks(columns);

				IColumn column = this.createColumn(columName, columSize, digits, columTypeName, nullable, withDefault, colRemarks);
			
				this.columnMap.put(column.getColumnName(), column);
				tmp.add(column.getColumnName());

			}
			
			if (isNull) {
				throw new RuntimeException(schema + "." + tableName + "获取列失败");
			}
			this.columnArray = tmp.toArray(new String[tmp.size()]);

			columns.close();
		}
		
		
	}
	/**
     * 通过第一条记录获得空间属性
     * @param colunmName
     * @return
     * @throws SQLException
     */

	@Override 
    protected GeoBuffer getGeoBufferInfoByData(String colunmName) throws SQLException{
        String sql = "select " + colunmName + " from " + this.schema + "." + this.tableName;
        Map<String,Type> typeMap = new HashMap<String,Type>();
        typeMap.put(colunmName, TypeOracleGeometry.INSTANCE);
        
        List<Map<String,?>> i = this.genericDao.queryBySql(sql, null, null, null, 0, 1, null,  SQLTransformer.MAP);
        if(i.isEmpty()){
            return null;
        }else{
            Map<String,?> data = i.get(0);
            Object o = data.get(colunmName);
            if(o == null) {
                return null;
            }
            GeoBuffer geo = (GeoBuffer) data.get(colunmName);
            return geo;
        }
    }

    

}