package com.northpool.resources.datatablebuilder.db.column;


import com.northpool.commons.util.Functions;
import com.northpool.resources.Constants.SPATIAL_TYPE;
import com.northpool.resources.datatablebuilder.AbstractColumn;
import com.northpool.resources.datatablebuilder.IColumn;
import com.northpool.resources.datatablebuilder.db.KingbaseTableBuilder;
import com.northpool.resources.dialect.db.SQLDialect;
import com.northpool.resources.type.Types;

public class KingbaseColumn extends AbstractColumn implements IColumn {

	protected KingbaseTableBuilder kingbaseTableBuilder;

	public KingbaseColumn(String columnName, int columnSize, int digits,
                          String columnTypeName, boolean nullable, boolean withDefault, String remarks, SQLDialect sqlDialect) {
		super(columnName, columnSize, digits, columnTypeName, nullable, withDefault, remarks,sqlDialect);
		// TODO Auto-generated constructor stub
	}



	@Override
	protected void initAttType() {
		// TODO Auto-generated method stub
	
		// System.out.println(this.colname+":"+this.columnTypeName+":"+this.digits+":"+this.colsize);
		/*if (Functions.hasMask(this.columnTypeName, "date")) {
			this.type = "java.util.Date";
		} else if (Functions.hasMask(this.columnTypeName, "NUMBER") || Functions.hasMask(this.columnTypeName, "NUMERIC")) {
			if (this.columnSize <= 10) {
				this.type = "Integer";
			}else{
				this.type = "java.math.BigDecimal";
			}
		} else if (Functions.hasMask(this.columnTypeName, "decimal")) {
			this.type = "java.math.BigDecimal";
		} else if (Functions.hasMask(this.columnTypeName, "timestamp")) {
			this.type = "java.sql.Timestamp";
		} else if (Functions.hasMask(this.columnTypeName, "small")) {
			this.type = "Short";
		} else if (Functions.hasMask(this.columnTypeName, "bigint")) {
			this.type = "Long";
		} else if (Functions.hasMask(this.columnTypeName, "Integer") || Functions.hasMask(this.columnTypeName, "int")
				|| Functions.hasMask(this.columnTypeName, "serial")) {
			this.type = "Integer";
		} else if (Functions.hasMask(this.columnTypeName, "double")) {
			this.type = "Double";
		} else if (Functions.hasMask(this.columnTypeName, "Float")) {
			this.type = "Float";
		} else if (Functions.hasMask(this.columnTypeName, "GEOMETRY")) {
			this.type = "com.northpool.spatial.postgresql.PostgisGeometry";
			this.columnSize = 0;
			this.isSpatial = true;
			
		} else if(Functions.hasMask(this.columnTypeName, "bytea") || Functions.hasMask(this.columnTypeName, "oid")){
			this.type = "java.sql.Blob";
			this.columnSize = 0;
		}*/
		if (Functions.hasMask(this.columnTypeName, "NUMBER") || Functions.hasMask(this.columnTypeName, "NUMERIC")){
			if (this.columnSize <= 10) {
				this.type =Types.INTEGER;
			}else{
				this.type = Types.BIGDECIMAL;
			}
		}else{
			this.type = this.dialect.getTypeByName(this.columnTypeName);
		}
		if(Functions.hasMask(this.columnTypeName, "GEOMETRY")){
			this.isSpatial = true;
		}
	}



    /* (non-Javadoc)
     * @see com.northpool.resources.datatablebuilder.IColumn#getSpatialType()
     */
    @Override
    public SPATIAL_TYPE getSpatialType() {
        // TODO Auto-generated method stub
        return SPATIAL_TYPE.kinggis;
    }



	
	
	


}
