package com.northpool.resources.datatablebuilder.db.column;

import com.northpool.commons.util.Functions;
import com.northpool.resources.Constants.SPATIAL_TYPE;
import com.northpool.resources.datatablebuilder.AbstractColumn;
import com.northpool.resources.datatablebuilder.IColumn;
import com.northpool.resources.datatablebuilder.db.MySQLTableBuilder;
import com.northpool.resources.dialect.db.SQLDialect;

public class MySQLColumn extends AbstractColumn implements IColumn {

	protected MySQLTableBuilder mysqlTableBuilder;

	public MySQLColumn(String columnName, int columnSize, int digits, String columnTypeName,
			boolean nullable, boolean withDefault, String remarks, SQLDialect sqlDialect) {
		super(columnName, columnSize, digits, columnTypeName, nullable, withDefault, remarks, sqlDialect);
	}

	@Override
	protected void initAttType() {
	   
		this.type = this.dialect.getTypeByName(this.columnTypeName);
		if (Functions.hasMask(this.columnTypeName, "GEOMETRY")) {
			this.isSpatial = true;
		}
	}

    /* (non-Javadoc)
     * @see com.northpool.resources.datatablebuilder.IColumn#getSpatialType()
     */
    @Override
    public SPATIAL_TYPE getSpatialType() {
        // TODO Auto-generated method stub
        return SPATIAL_TYPE.mysql;
    }

}
