package com.northpool.resources.datatablebuilder.db.column;

import com.northpool.commons.util.Functions;
import com.northpool.resources.Constants.SPATIAL_TYPE;
import com.northpool.resources.datatablebuilder.AbstractColumn;
import com.northpool.resources.datatablebuilder.IColumn;
import com.northpool.resources.datatablebuilder.db.OracleTableBuilder;
import com.northpool.resources.dialect.db.SQLDialect;
import com.northpool.resources.type.Types;

public class OracleColumn extends AbstractColumn implements IColumn {

	protected OracleTableBuilder oracleTableBuilder;

	public OracleColumn(String columnName, int columnSize, int digits, String columnTypeName,
			boolean nullable, boolean withDefault, String remarks, SQLDialect sqlDialect) {
		super(columnName, columnSize, digits, columnTypeName, nullable, withDefault, remarks, sqlDialect);
	}

	@Override
	protected void initAttType() {
		if (Functions.hasMask(this.columnTypeName, "NUMBER") || Functions.hasMask(this.columnTypeName, "NUMERIC")) {
			if (this.columnSize <= 10) {
				this.type = Types.INTEGER;
			} else {
				this.type = Types.BIGDECIMAL;
			}
		} else {
			this.type = this.dialect.getTypeByName(this.columnTypeName);
		}
		if (Functions.hasMask(this.columnTypeName, "GEOMETRY")) {
			this.isSpatial = true;
		}
	}

    /* (non-Javadoc)
     * @see com.northpool.resources.datatablebuilder.IColumn#getSpatialType()
     */
    @Override
    public SPATIAL_TYPE getSpatialType() {
        // TODO Auto-generated method stub
        return SPATIAL_TYPE.sdo;
    }

}
