package com.northpool.resources.dialect.db;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

import com.northpool.resources.dialect.AbstractDialect;
import com.northpool.resources.dialect.function.sql.SQLFunction;
import com.northpool.resources.type.Type;
import com.northpool.resources.type.TypeInteger;



public abstract class AbstractSQLDialect extends AbstractDialect  {
	
	
	protected static final String INSERT = "insert";
	
	protected static final String VALUES = "values";
	
	protected static final String UPDATE = "update";

	protected static final String DELETE = "delete";
	
	
	public SQLFunction getFunction(String functionName){
		return (SQLFunction) this.getFunctions().get(functionName.toLowerCase());
	}
	
	
	abstract public Boolean markForTableNameAndColumnName();
	
	public String processTableNameAndSchema(String schema,String tableName){
        if(schema != null && !"".equalsIgnoreCase(schema)){
            return schema + "." + tableName;
        }else{
            return tableName;
        }
    }
	
    public String getLimitString(String sql, boolean hasOffset, List<Object> parameterList, List<Type> inputTypes, int firstResult, int maxResults) {
        parameterList.add(maxResults - firstResult);
        inputTypes.add(TypeInteger.INSTANCE);
        return new StringBuilder(sql.length() + 20).append(sql).append(hasOffset ? " limit ? offset ?" : " limit ?")
                .toString();
    }

	
	public String createInsertSQL(String schema,String tableName,String[] fields){
		String fieldsPart;
		if(this.markForTableNameAndColumnName()){
			for(int index = 0 ; index < fields.length ; index ++){
				fields[index] = new StringBuilder().append("\"").append(fields[index]).append("\"").toString();
			}
		}
		fieldsPart = StringUtils.join(fields,",");
		
		
		String[] argsPartArr = new String[fields.length];
		Arrays.fill(argsPartArr, "?");
		String argsPart = StringUtils.join(argsPartArr ,",");
		String sql = new StringBuilder(INSERT).append(" into ").append(this.processTableNameAndSchema(schema,tableName)).append(" (").append(fieldsPart).append(") ").append(VALUES).append(" (").append(argsPart).append(")").toString();
		return sql;
	}
	
	public String createUpdateSQL(String schema,String tableName,String[] fields,String where){
	    String fieldsPart;
        if(this.markForTableNameAndColumnName()){
            for(int index = 0 ; index < fields.length ; index ++){
                fields[index] = new StringBuilder().append("\"").append(fields[index]).append("\"").append(" = ? ").toString();
            }
        }
        fieldsPart = StringUtils.join(fields,",");
        StringBuilder sqlBuilder = new StringBuilder(UPDATE).append(" ").append(this.processTableNameAndSchema(schema,tableName)).append(" set ").append(fieldsPart);
        if(where != null){
            sqlBuilder.append(" where ").append(where);
        }
        return sqlBuilder.toString();
	}
	
	public String createDeleteSQL(String schema,String tableName,String where){
	    StringBuilder sqlBuilder = new StringBuilder(DELETE).append(" from ").append(this.processTableNameAndSchema(schema,tableName));
	    if(where != null){
	        sqlBuilder.append(" where ").append(where);
	    }
	    return sqlBuilder.toString();
	    
	}

	 
    public void setFetchSize(Connection connection, PreparedStatement preparedStatement, Integer fetchSize) throws SQLException {
        // TODO Auto-generated method stub
        preparedStatement.setFetchSize(fetchSize);
        preparedStatement.setFetchDirection(ResultSet.FETCH_FORWARD);
    }
	
	
	
//	abstract public String createInsertSQLWithSequence();
	
//	abstract public String getSequenceNextValString(String sequenceName);

//	abstract public String getSelectSequenceNextValString(String sequenceName);
	
//	abstract public String getCreateSequenceString(String sequenceName); 

//	abstract public String getDropSequenceString(String sequenceName) ;
	
	

	
	
	 
	
	
	
	
	
	
}
