package com.northpool.resources.dialect.db;




import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.db.kingbase.KingbaseDialect;
import com.northpool.resources.dialect.db.mysql.MySQLDialect;
import com.northpool.resources.dialect.db.oracle.OracleSQLDialect;
import com.northpool.resources.dialect.db.postgresql.PostgreSQLDialect;
import com.northpool.resources.dialect.function.sql.SQLFunction;
import com.northpool.resources.type.Type;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;

public interface SQLDialect extends IDialect{
	
	/**
	 * 判断是否是SQL中使用的系统字段,比如说是oracle分页的rownum
	 * @param Filed
	 * @return
	 */
	default public boolean isSystemMarkFiled(String filedName){
	    return false;
	}
    
    
	
	
	public static SQLDialect getSQLDialect(DATA_SOURCE_TYPE type) {
		switch(type){
			/*case mysql:
				
				break;*/
			case postgreSQL:
				return PostgreSQLDialect.INSTANCE;
			case oracle:
				return OracleSQLDialect.INSTANCE;
			case mysql:
				return MySQLDialect.INSTANCE;
			case kingbase:
				return KingbaseDialect.INSTANCE;
			/*case oracle:
				break;*/
		}
		throw new RuntimeException("SQLDialect不支持" + type);
		
	}
	
	public Type getTypeByName(String typeName);
	
	public Type getTypeByObject(Object arg);
	
	public String getLimitString(String sql, boolean hasOffset, List<Object> parameterList, List<Type> inputTypes, int firstResult, int maxResults);
	
	public SQLFunction getFunction(String functionName);
	
	public String getJDBCDriver();
	
	public String createConnectUrl(String url);
	
	public Boolean markForTableNameAndColumnName(); 
	
	

    /**
     * @param connection
     * @param preparedStatement
     * @param fetchSize
     */
    public void setFetchSize(Connection connection, PreparedStatement preparedStatement, Integer fetchSize) throws SQLException;
    
    
    public String processTableNameAndSchema(String schema,String tableName);
    
    public String createInsertSQL(String schema,String tableName,String[] fields);
	
    public String createDeleteSQL(String schema,String tableName,String where);
    
    public String createUpdateSQL(String schema, String tableName,String[] fields,String where);
    
    public String getDefaultSchema();
    

	
}
