package com.northpool.resources.dialect.db.kingbase;


import com.northpool.resources.Constants.DATA_BASE_TYPE;
import com.northpool.resources.dialect.db.AbstractSQLDialect;
import com.northpool.resources.dialect.db.SQLDialect;
import com.northpool.resources.dialect.function.sql.SQLSpatialRelateFunction;
import com.northpool.resources.dialect.function.sql.SpatialFilterExpression;
import com.northpool.resources.type.*;
import com.northpool.spatial.geofeature.GeoBuffer;
import org.locationtech.jts.geom.Geometry;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;


public class KingbaseDialect extends AbstractSQLDialect implements SQLDialect {

	public static KingbaseDialect INSTANCE = new KingbaseDialect();

	public KingbaseDialect(){

		super();
		this.name = DATA_BASE_TYPE.kingbase.name();
		
	}
	
	@Override
	public DATA_BASE_TYPE getDataSourceType() {
		return DATA_BASE_TYPE.kingbase;
	}
	
	@Override
	protected void registerTypes(){
		this.registerType(Types.INTEGER, "serial","int", "int2", "int4", "integer");
		this.registerClassType(Types.INTEGER, Integer.class,Short.class);
		this.registerType(TypeKingbaseGeometry.INSTANCE, "geometry");
		this.registerClassType(TypeKingbaseGeometry.INSTANCE, Geometry.class,GeoBuffer.class);
		this.registerType(Types.STRING, "varchar","bpchar","character varying","text","json","jsonb","path");
		this.registerClassType(Types.STRING, String.class);
		this.registerType(Types.DOUBLE, "float","float4","float8","double");
		this.registerClassType(Types.DOUBLE, Double.class,Float.class);
		this.registerType(Types.BIGDECIMAL, "numeric","number");
		this.registerClassType(Types.BIGDECIMAL, BigDecimal.class,BigInteger.class);
		this.registerType(Types.TIME_STAMP, "timestamp","date");
		this.registerClassType(Types.TIME_STAMP, Date.class);
		this.registerType(Types.BOOLEAN, "boolean", "bool");
		this.registerClassType(Types.BOOLEAN, Boolean.class);	
		this.registerType(Types.LONG, "long","int8");
		this.registerClassType(Types.LONG, Long.class); 
		this.registerType(TypeBytes.INSTANCE, "bytea","byte[]");
        this.registerClassType(TypeBytes.INSTANCE, byte[].class); 
	}
	
	//public com.northpool.resources.type.Type getInputType(java.lang.Object obj){if( obj instanceof java.lang.Long){ return com.northpool.resources.type.TypeLong.INSTANCE;};if( obj instanceof java.math.BigInteger){ return com.northpool.resources.type.TypeBigDecimal.INSTANCE;};if( obj instanceof java.util.Date){ return com.northpool.resources.type.TypeTimestamp.INSTANCE;};if( obj instanceof com.northpool.spatial.geofeature.GeoBuffer){ return com.northpool.resources.type.TypePGGeometry.INSTANCE;};if( obj instanceof java.math.BigDecimal){ return com.northpool.resources.type.TypeBigDecimal.INSTANCE;};if( obj instanceof java.lang.Short){ return com.northpool.resources.type.TypeInteger.INSTANCE;};if( obj instanceof java.lang.Double){ return com.northpool.resources.type.TypeDouble.INSTANCE;};if( obj instanceof java.lang.Float){ return com.northpool.resources.type.TypeDouble.INSTANCE;};if( obj instanceof java.lang.Boolean){ return com.northpool.resources.type.TypeBoolean.INSTANCE;};if( obj instanceof org.locationtech.jts.geom.Geometry){ return com.northpool.resources.type.TypePGGeometry.INSTANCE;};if( obj instanceof java.lang.String){ return com.northpool.resources.type.TypeString.INSTANCE;};if( obj instanceof [B){ return com.northpool.resources.type.TypeBytes.INSTANCE;};if( obj instanceof java.lang.Integer){ return com.northpool.resources.type.TypeInteger.INSTANCE;};return null;}

	@Override
	public String getSelfDesc() {
		// TODO Auto-generated method stub
		return "Kingbase方言";
	}

	
	@Override
	protected void registerFunctions() {
		Type[] typeIn = new Type[]{TypeKingbaseGeometry.INSTANCE,TypeKingbaseGeometry.INSTANCE};
		//注册空间关系函数
		this.registerFunction("intersects", new SQLSpatialRelateFunction("st_intersects", Types.BOOLEAN,typeIn));
		this.registerFunction("equals", new SQLSpatialRelateFunction("st_equals", Types.BOOLEAN,typeIn));
		this.registerFunction("contains", new SQLSpatialRelateFunction("st_contains", Types.BOOLEAN,typeIn));
		this.registerFunction("crosses", new SQLSpatialRelateFunction("st_crosses", Types.BOOLEAN,typeIn));
		this.registerFunction("disjoint", new SQLSpatialRelateFunction("st_disjoint", Types.BOOLEAN,typeIn));
		this.registerFunction("touches", new SQLSpatialRelateFunction("st_touches", Types.BOOLEAN,typeIn));
		this.registerFunction("within", new SQLSpatialRelateFunction("st_within", Types.BOOLEAN,typeIn));
		this.registerFunction("overlaps", new SQLSpatialRelateFunction("st_overlaps", Types.BOOLEAN,typeIn));
		this.registerFunction("mbr_intersects", new SpatialFilterExpression(Types.BOOLEAN,typeIn));
	//	this.registerFunction("relate", new SpatialRelateFunction("st_relate", Types.BOOLEAN,typeIn));
	}

	
	
	


	@Override
	public String getJDBCDriver() {
		return "com.kingbase8.Driver";
	}

	@Override
	public String createConnectUrl(String url) {
		return "jdbc:kingbase8://" + url;
	}

	@Override
	public Boolean markForTableNameAndColumnName() {
		// TODO Auto-generated method stub
		return true;
	}

	
	
	
	

	
/*	protected void registerTypesAndFunctions() {
		// registerColumnType(java.sql.Types.STRUCT, "geometry");
		registerFunction("dimension", new SpatialRelateFunction("st_dimension", Types.INTEGER));
		registerFunction("geometrytype", new StandardSQLFunction("st_geometrytype", Types.STRING));
		registerFunction("srid", new StandardSQLFunction("st_srid", Types.INTEGER));
		registerFunction("envelope", new SpatialRelateFunction("st_envelope", Types.GEOMETRY));
		registerFunction("astext", new SpatialRelateFunction("st_astext", Types.STRING));
		registerFunction("asbinary", new SpatialRelateFunction("st_asbinary", Types.BINARY));
		registerFunction("isempty", new SpatialRelateFunction("st_isempty", Types.BOOLEAN));
		registerFunction("issimple", new SpatialRelateFunction("st_issimple", Types.BOOLEAN));
		registerFunction("boundary", new SpatialRelateFunction("st_boundary", Types.GEOMETRY));

		// Register functions for spatial relation constructs
		registerFunction("overlaps", new SpatialRelateFunction("st_overlaps", Types.BOOLEAN));
		registerFunction("intersects", new SpatialRelateFunction("st_intersects", Types.BOOLEAN));
		registerFunction("equals", new SpatialRelateFunction("st_equals", Types.BOOLEAN));
		registerFunction("contains", new SpatialRelateFunction("st_contains", Types.BOOLEAN));
		registerFunction("crosses", new SpatialRelateFunction("st_crosses", Types.BOOLEAN));
		registerFunction("disjoint", new SpatialRelateFunction("st_disjoint", Types.BOOLEAN));
		registerFunction("touches", new SpatialRelateFunction("st_touches", Types.BOOLEAN));
		registerFunction("within", new SpatialRelateFunction("st_within", Types.BOOLEAN));
		registerFunction("relate", new SpatialRelateFunction("st_relate", Types.BOOLEAN));

		// register the spatial analysis functions
		registerFunction("distance", new SpatialRelateFunction("st_distance", Types.DOUBLE));
		registerFunction("buffer", new SpatialRelateFunction("st_buffer", Types.GEOMETRY));
		registerFunction("convexhull", new SpatialRelateFunction("st_convexhull", Types.GEOMETRY));
		registerFunction("difference", new SpatialRelateFunction("st_difference", Types.GEOMETRY));
		registerFunction("intersection", new SpatialRelateFunction("st_intersection", Types.GEOMETRY));
		registerFunction("symdifference", new StandardSQLFunction("st_symdifference", Types.GEOMETRY));
		registerFunction("geomunion", new SpatialRelateFunction("st_union", Types.GEOMETRY));

		// register Spatial Aggregate function
		registerFunction("extent", new SpatialRelateFunction("extent", Types.GEOMETRY));

		// other common functions
		registerFunction("dwithin", new SpatialRelateFunction("st_dwithin", Types.BOOLEAN));
		registerFunction("transform", new SpatialRelateFunction("st_transform", Types.GEOMETRY));

		registerFunction("mbrintersects", new SpatialRelateFunction("st_transform", Types.GEOMETRY));
	}

	public String getSpatialRelateSQL(String columnName, int spatialRelation) {
		switch (spatialRelation) {
		case SpatialRelation.WITHIN:
			return " ST_within(" + columnName + ",?)";
		case SpatialRelation.CONTAINS:
			return " ST_contains(" + columnName + ", ?)";
		case SpatialRelation.CROSSES:
			return " ST_crosses(" + columnName + ", ?)";
		case SpatialRelation.OVERLAPS:
			return " ST_overlaps(" + columnName + ", ?)";
		case SpatialRelation.DISJOINT:
			return " ST_disjoint(" + columnName + ", ?)";
		case SpatialRelation.INTERSECTS:
			return " ST_intersects(" + columnName + ", ?)";
		case SpatialRelation.TOUCHES:
			return " ST_touches(" + columnName + ", ?)";
		case SpatialRelation.EQUALS:
			return " ST_equals(" + columnName + ", ?)";
		default:
			throw new IllegalArgumentException("Spatial relation is not known by this dialect");
		}
	}

	public String getDWithinSQL(String columnName) {
		return "ST_DWithin(" + columnName + ",?,?)";
	}

	public String getHavingSridSQL(String columnName) {
		return "( ST_srid(" + columnName + ") = ?)";
	}

	public String getIsEmptySQL(String columnName, boolean isEmpty) {
		String emptyExpr = " ST_IsEmpty(" + columnName + ") ";
		return isEmpty ? emptyExpr : "( NOT " + emptyExpr + ")";
	}

	public String getSpatialFilterExpression(String columnName) {
		return "(" + columnName + " && ? ) ";
	}
	*/
	
	
	public void setFetchSize(Connection connection, PreparedStatement preparedStatement, Integer fetchSize) throws SQLException {
        // TODO Auto-generated method stub
	    connection.setAutoCommit(false);
        preparedStatement.setFetchSize(fetchSize);
        preparedStatement.setFetchDirection(ResultSet.FETCH_FORWARD);
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.dialect.db.SQLDialect#getDefaultSchema()
     */
    @Override
    public String getDefaultSchema() {
        // TODO Auto-generated method stub
        return "public";
    }

    


	/*
	 * public String getSpatialAggregateSQL(String columnName, int aggregation)
	 * { switch (aggregation) { case SpatialAggregate.EXTENT: StringBuilder
	 * stbuf = new StringBuilder();
	 * stbuf.append("extent(").append(columnName).append(")"); return
	 * stbuf.toString(); default: throw new
	 * IllegalArgumentException("Aggregation of type " + aggregation +
	 * " are not supported by this dialect"); } }
	 */
	

}
