package com.northpool.resources.dialect.db.mysql;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

import org.locationtech.jts.geom.Geometry;

import com.northpool.resources.Constants.DATA_BASE_TYPE;
import com.northpool.resources.dialect.db.AbstractSQLDialect;
import com.northpool.resources.dialect.db.SQLDialect;
import com.northpool.resources.dialect.function.sql.StandardSQLFunction;
import com.northpool.resources.type.Type;
import com.northpool.resources.type.TypeInteger;
import com.northpool.resources.type.TypeMySQLGeometry;
import com.northpool.resources.type.Types;

public class MySQLDialect extends AbstractSQLDialect implements SQLDialect {

	public static MySQLDialect INSTANCE = new MySQLDialect();

	public MySQLDialect() {
		super();
		this.name = DATA_BASE_TYPE.mysql.name();
		this.registerTypesAndFunctions();
	}

	@Override
	public DATA_BASE_TYPE getDataSourceType() {
		return DATA_BASE_TYPE.mysql;
	}

	
	
	@Override
	public String getSelfDesc() {
		return "MySql方言";
	}
	@Override
	public String getJDBCDriver() {
		return "com.mysql.jdbc.Driver";
		//return "com.mysql.cj.jdbc.Driver" //8.0;
	}
	@Override
	public String createConnectUrl(String url) {
		return "jdbc:mysql://" + url;
	}

	@Override
	protected void registerTypes() {
		this.registerType(Types.INTEGER, "INTEGER", "INT");
		this.registerClassType(Types.INTEGER, Integer.class);

		this.registerType(Types.DOUBLE, "DOUBLE");
		this.registerClassType(Types.DOUBLE, Double.class);

		this.registerType(TypeMySQLGeometry.INSTANCE, "GEOMETRY");
		this.registerClassType(TypeMySQLGeometry.INSTANCE, Geometry.class);

		this.registerType(Types.STRING, "VARCHAR", "CHAR");
		this.registerClassType(Types.STRING, String.class);

		this.registerType(Types.BIGDECIMAL, "DECIMAL");
		this.registerClassType(Types.BIGDECIMAL, BigDecimal.class);

		this.registerType(Types.TIME_STAMP, "DATE", "TIMESTAMP");
		this.registerClassType(Types.TIME_STAMP, Date.class);
	}

	protected void registerTypesAndFunctions() {
		this.registerTypes();
		this.registerFunctions();
	}
	@Override
	protected void registerFunctions() {
		Type[] typeIn = new Type[] { TypeMySQLGeometry.INSTANCE, TypeMySQLGeometry.INSTANCE };
		// 注册空间关系函数,return 1(true);0(false);
		this.registerFunction("intersects", new SpatialRelateFunction("intersects", Types.VOID, typeIn));
		this.registerFunction("equals", new SpatialRelateFunction("equals", Types.VOID, typeIn));
		this.registerFunction("contains", new SpatialRelateFunction("contains", Types.VOID, typeIn));
		this.registerFunction("crosses", new SpatialRelateFunction("crosses", Types.VOID, typeIn));
		this.registerFunction("disjoint", new SpatialRelateFunction("disjoint", Types.VOID, typeIn));
		this.registerFunction("touches", new SpatialRelateFunction("touches", Types.VOID, typeIn));
		this.registerFunction("within", new SpatialRelateFunction("within", Types.VOID, typeIn));
	}

	public class SpatialRelateFunction extends StandardSQLFunction {

		public SpatialRelateFunction(String name, Type returnType, Type[] argumentsType) {
			super(name, argumentsType, returnType);
		}

		@Override
		public Boolean isSpatial() {
			return true;
		}

	}

	@Override
	public Boolean markForTableNameAndColumnName() {
		// TODO Auto-generated method stub
		return false;
	}

    /* (non-Javadoc)
     * @see com.northpool.resources.dialect.db.SQLDialect#getDefaultSchema()
     */
    @Override
    public String getDefaultSchema() {
        // TODO Auto-generated method stub
        return null;
    }
}