package com.northpool.resources.sql;



import java.sql.SQLException;
import java.util.List;

import com.northpool.resources.datatable.Scroll;
import com.northpool.resources.type.Type;

public interface Query<T,Trans> {
	public Query<T,Trans> setResultTransformer(Trans transformer);
	public Query<T,Trans> addScalar(String key,Type type);
	public Query<T,Trans> setParameter(int index ,Object arg);
	public Query<T,Trans> setFirstResult(Integer firstResult);
	public Query<T,Trans> setMaxResults(Integer maxResults);
	public Query<T,Trans> setFetchSize(Integer fetchSize);
	//public List<?> list(Integer fetchSize) throws SQLException;
	public List<T> list() throws SQLException ;
	public Scroll<T> scroll() throws SQLException;
	
	
}
