package com.northpool.resources.sql;

import com.northpool.resources.command.CommandImpl.*;
import com.northpool.resources.command.Constants.OPERATION;
import com.northpool.resources.command.Constants.RELATION;
import com.northpool.resources.command.ICommand;
import com.northpool.resources.command.ICommandStructure;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datatable.FieldDecoder;
import com.northpool.resources.dialect.db.SQLDialect;
import com.northpool.resources.dialect.function.Function;
import com.northpool.resources.dialect.function.sql.SQLFunction;
import com.northpool.resources.type.Type;
import com.northpool.resources.type.TypeVoid;
import com.northpool.resources.type.Types;

import java.util.*;

public class QueryFilterToSQL {
	
	/*public static QueryFilterToSQL _QueryFilterToSQL = new QueryFilterToSQL();
	public static QueryFilterToSQL getIntance(){
		return _QueryFilterToSQL;
	}*/
    QueryFilter queryFilter;
    String aliasTable;
    SQLDialect dialect;
    FieldDecoder fieldDecoder;
    Map<String, Type> parameterTypeMap;

    public QueryFilterToSQL(QueryFilter queryFilter, SQLDialect dialect, Map<String, Type> parameterTypeMap,
        FieldDecoder fieldDecoder) {
        this.dialect = dialect;
        this.fieldDecoder = fieldDecoder;
        this.queryFilter = queryFilter;
        // this.aliasTable = aliasTable;
        this.parameterTypeMap = parameterTypeMap;
    }

    public static final String SPACE = " ";
    public static final String AND = " and ";
    public static final String OR = " or ";
    public static final String NOT = " not ";
    List<Object> values = new ArrayList<Object>();
    StringBuilder wherePart = new StringBuilder();
    List<Type> types = new ArrayList<Type>();
	
	
	public WherePartSQL toWherePartSQL(){
		StringBuilder stringBuilder = new StringBuilder();
		this.translate(stringBuilder);
		if(stringBuilder.length() == 0){
			return null; 
		}
		WherePartSQL part = new WherePartSQL();
		part.types = types;
		part.values = values;
		part.wherePart = stringBuilder.toString();
		return part;
	}
	
	
	protected void translate(StringBuilder stringBuilder){
		List<ICommand> iList = queryFilter.getCommands();
		for(int i = 0 ; i < iList.size() ; i ++){
			ICommand command = iList.get(i);
			StringBuilder subStringBuilder = this.toSQL(command);
			RELATION relation = command.getRelation();
			if(i == 0 ){
				if(relation != RELATION.NOT){
					this.addToStructure(RELATION.NONE,subStringBuilder,stringBuilder);
				}else{
					this.addToStructure(relation,subStringBuilder,stringBuilder);
				}
			}else{
				this.addToStructure(relation,subStringBuilder,stringBuilder);
			}
		}
	}
	
	protected StringBuilder toSQL(ICommand command){
		command.build(dialect);
		//SQLParameter parameter = new SQLParameter();
		if (command instanceof MultipleParametersCommand) {
			MultipleParametersCommand multipleParametersCommand = (MultipleParametersCommand)command;
			return this.toSQL(multipleParametersCommand);
		} 
		if (command instanceof FunctionCommand || command instanceof SpatialCommand) {
			FunctionCommand functionCommand = (FunctionCommand)command;
			return this.toSQL(functionCommand);
		} 
		if(command instanceof FieldCommand){
			FieldCommand fieldCommand = (FieldCommand)command;
			return this.toSQL(fieldCommand);
		}
		if(command instanceof ICommandStructure){
			ICommandStructure commandStructure = (ICommandStructure)command;
			return this.toSQL(commandStructure);
		}
		
		
		return null;
	
	}
	
	
	protected StringBuilder toSQL(ICommandStructure commandStructure){
		//commandStructure.build(this.dialect);
		Iterator<ICommand> iterator = commandStructure.getCommands().iterator();
		StringBuilder stringBuilder = new StringBuilder();
		stringBuilder.append("(");
		int mark = 0;
		while(iterator.hasNext()){
			ICommand command = (ICommand)iterator.next();
			if(command instanceof SortCommand){
				iterator.remove();
			}
			if(command instanceof ICommandStructure){
				ICommandStructure  subCommandStructure = (ICommandStructure)command;
				if(subCommandStructure.getCommands().size() == 0){
					iterator.remove();
				}
			}
			StringBuilder subStringBuilder = this.toSQL(command);
			if(mark == 0){
				if(command.getRelation() != RELATION.NOT){
					this.addToStructure(RELATION.NONE,subStringBuilder,stringBuilder);
				}else{
					this.addToStructure(command.getRelation(),subStringBuilder,stringBuilder);
				}
			}else{
				this.addToStructure(command.getRelation(),subStringBuilder,stringBuilder);
			}
			mark ++;
		}	
		
		
		if(stringBuilder.toString().trim().length() != 0){
			stringBuilder.append(")");
		}
		return stringBuilder;
	}
	
	protected StringBuilder toSQL(FieldCommand command){
		//command.build(this.dialect);
		StringBuilder stringBuilder = new StringBuilder();
		OPERATION operation = command.getOperation();
		String property = command.getProperty();
		Object value = command.getValue();
		Type fieldType = this.getFieldType(property);
		if(value != null){
			if(!fieldType.isType(value)){
				try {
					value = fieldType.toType(value);
				} catch (Exception e) {
					// TODO Auto-generated catch block
					e.printStackTrace();
					throw new RuntimeException("类型" + value.getClass() + "不能转换为类型" + fieldType.name() + "." + this.dialect.getSelfDesc());
				}
			}
		}
		
		this.processColnumField(stringBuilder, property);
		this.addConditionPart(stringBuilder, operation, value,fieldType);
		return stringBuilder;
	}
	
	protected Type getFieldType(String fieldName){
		Type type = this.parameterTypeMap.get(fieldName);
		if(type == null){
			return Types.UNKNOWN;
		}
		return type;
	}
	
	protected StringBuilder toSQL(MultipleParametersCommand command){
		//command.build(this.dialect);
		StringBuilder stringBuilder = new StringBuilder();
		OPERATION operation = command.getOperation();
		String property = command.getProperty();
		Object[] values = command.getValues();
		Type fieldType = this.getFieldType(property);
		for(int i = 0 ; i < values.length ; i ++){
			if(values[i] != null){
				if(!fieldType.isType(values[i])){
					try {
						values[i] = fieldType.toType(values[i]);
					} catch (Exception e) {
						// TODO Auto-generated catch block
						e.printStackTrace();
						throw new RuntimeException("类型" + values[i].getClass() + "不能转换为类型" + fieldType.name() + "." + this.dialect.getSelfDesc());
					}
				}
			}
		}
		this.processColnumField(stringBuilder, property);
		this.addConditionPart(stringBuilder, operation, Arrays.asList(values),fieldType);
		return stringBuilder;
	}
	
	protected StringBuilder toSQL(FunctionCommand command){
		//command.build(this.dialect);
		String functionName = command.getFunctionName();
		SQLFunction function = (SQLFunction) this.dialect.getFunction(functionName.toLowerCase());
		if(function == null){
			throw new RuntimeException(this.dialect.getSelfDesc() + "中找不到函数" + functionName);
		}
		Object[] leftvalues = command.getFunctionLeftvalues();
		Object rightValue = command.getFunctionRightValue();
		String[] columns = command.getColumnNames();
		Type[] types = function.getArgumentsType();
		//处理函数左边的参数
		for(int index = 0 ; index < types.length ; index ++){
			String column  = columns[index];
			Object leftvalue = leftvalues[index];
			Type type = types[index];
			if(Function.isParameter(column )){
				if(!type.isType(leftvalue)){
					try{
						leftvalue = type.toType(leftvalue);
					}catch(Exception e){
						e.printStackTrace();
						throw new RuntimeException("类型" + leftvalue.getClass() + "不能转换为" + this.dialect.getSelfDesc() + ",函数" + functionName + "的第 " + index + " 参数类型" + type.name());
					}
				}
				this.values.add(leftvalue);
				this.types.add(type);
			}else{
				StringBuilder columnSb = new StringBuilder();
				this.processColnumField(columnSb, column);
				columns[index] = columnSb.toString();
			}
		}
		//处理函数右边的参数
		Type returnType = function.getReturnType();
		if(returnType != null){
			if(returnType == TypeVoid.INSTANCE){
				
			}else if(!returnType.isType(rightValue)){
				try{
					rightValue = returnType.toType(rightValue);
				}catch(Exception e){
					e.printStackTrace();
					throw new RuntimeException("类型" + rightValue.getClass() + "不能转换为" + this.dialect.getSelfDesc() + ",函数" + functionName + "的 返回参数类型" + returnType.name());
				}
			}
		}
		
		StringBuilder stringBuilder = new StringBuilder();
		String functionSqlExpression = null;
		try {
			functionSqlExpression = function.render(Arrays.asList(columns));
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new RuntimeException("这里基本不可能出错,throw是为了满足接口而已");
		}
		stringBuilder.append(functionSqlExpression);
		OPERATION operation;
		//如果返回值type是空的情况下
		if(returnType == TypeVoid.INSTANCE){
			//需要将OPERATION变成 _null;
			operation = OPERATION._NULL;
		}else{
			operation = command.getOperation();
		}
		
		this.addConditionPart(stringBuilder, operation, rightValue,function.getReturnType());
		return stringBuilder;
	}
	
	
	
	
	
	protected StringBuilder addToStructure(RELATION relation,StringBuilder subStringBuilder,StringBuilder stringBuilder){
		switch(relation){
			case NONE:
				stringBuilder.append(subStringBuilder);
				return stringBuilder;
			case AND:
				stringBuilder.append(AND).append(subStringBuilder);
				return stringBuilder;
			case NOT:
				stringBuilder.append(NOT).append(subStringBuilder);
				return stringBuilder;
			case OR:
				stringBuilder.append(OR).append(subStringBuilder);
				return stringBuilder;
		}
		throw new RuntimeException("不支持关系relationTag:" + relation.name());	
		
	}
	
	protected void processColnumField(StringBuilder stringBuilder,String name){
		String nameInDB = this.fieldDecoder.decode(name);
		if(nameInDB == null){
			throw new RuntimeException(String.format("%s找不到字段%s的映射", this.fieldDecoder.getExceptionNameMark(), name));
		}
		if(dialect.markForTableNameAndColumnName()){
			stringBuilder.append("\"").append(this.fieldDecoder.decode(name)).append("\"");
		}else{
			stringBuilder.append(this.fieldDecoder.decode(name));
		}
		
		//stringBuilder.append(name);
	}
	
	
	
	
	
	protected boolean addConditionPart(StringBuilder structure,OPERATION operation,Object value,Type fieldType){
		switch(operation){
			case EQ :{
				structure.append(" = ? ");
				this.values.add(value);
				this.types.add(fieldType);
				return true;
			}
			case LT:{
				structure.append(" < ? ");
				this.values.add(value);
				this.types.add(fieldType);
				return true;
			}
			case NE:{
				structure.append(" <> ? ");
				this.values.add(value);
				this.types.add(fieldType);
				return true;
			}
			case IN:{
				List<Object> valuesIn = (List<Object>)value;
				if(valuesIn.size() == 0){
					return false;
				}
				structure.append(" in (");
				String[] v = new String[valuesIn.size()];
				Arrays.fill(v, "?");
				structure.append(String.join(",",v)).append(") ");
				this.values.addAll(valuesIn);
				Type[] types = new Type[valuesIn.size()];
				Arrays.fill(types, fieldType);
				this.types.addAll(Arrays.asList(types));
				return true;
			}
			case NOT_IN:{
				List<Object> valuesIn = (List<Object>)value;
				if(valuesIn.size() == 0){
					return false;
				}
				structure.append(" not in (");
				String[] v = new String[valuesIn.size()];
				Arrays.fill(v, "?");
				structure.append(String.join(",",v)).append(") ");
				this.values.addAll(valuesIn);
				Type[] types = new Type[valuesIn.size()];
                Arrays.fill(types, fieldType);
                this.types.addAll(Arrays.asList(types));
				return true;
			}
			case GT:{
				structure.append(" > ? ");
				this.values.add(value);
				this.types.add(fieldType);
				return true;
			}
			case LE:{
				structure.append(" <= ? ");
				this.values.add(value);
				this.types.add(fieldType);
				return true;
			}
			case GE:{
				structure.append(" >= ? ");
				this.values.add(value);
				this.types.add(fieldType);
				return true;
			}
			case LK:{
				structure.append(" like ? ");
				this.values.add(value);
				this.types.add(fieldType);
				return true;
			}
			case NOT_LK:{
				structure.append(" not like ? ");
				this.values.add(value);
				this.types.add(fieldType);
				return true;
			}
			case LFK:{
			    if(!fieldType.name().equalsIgnoreCase("string")){
			        throw new RuntimeException("like只能对应字符串类型"); 
			    }
				structure.append(" like ? ");
				this.values.add(new StringBuilder().append(String.valueOf(value)).append("%").toString());
				this.types.add(fieldType);
				return true;
			}
			case NOT_LFK:{
			    if(!fieldType.name().equalsIgnoreCase("string")){
                    throw new RuntimeException("like只能对应字符串类型"); 
                }
				structure.append(" not like ? ");
				this.values.add(new StringBuilder().append(String.valueOf(value)).append("%").toString());
				this.types.add(fieldType);
				return true;
			}
			case RHK:{
			    if(!fieldType.name().equalsIgnoreCase("string")){
                    throw new RuntimeException("like只能对应字符串类型"); 
                }
				structure.append(" like ? ");
				this.values.add(new StringBuilder().append("%").append(String.valueOf(value)).toString());
				this.types.add(fieldType);
				return true;
			}
			case NOT_RHK:{
			    if(!fieldType.name().equalsIgnoreCase("string")){
                    throw new RuntimeException("like只能对应字符串类型"); 
                }
				structure.append(" not like ? ");
				this.values.add(new StringBuilder().append("%").append(String.valueOf(value)).toString());
				this.types.add(fieldType);
				return true;
			}
			case IS_NULL:{
				structure.append(" is null ");
				return true;
			}
			case IS_NOT_NULL:{
				structure.append(" is not null ");
				return true;
			}
			case _NULL:{
				return true;
			}
		}
		throw new RuntimeException("不支持关系" + operation.name());	
	}
	
	public class WherePartSQL{
	    public List<Object> values;
	    public String wherePart;
	    public List<Type> types;
	}
	
	
	
	
	

	
}
