package com.northpool.resources.sql;

import java.util.List;
import java.util.Map;

import com.northpool.resources.datatable.Scroll;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.sql.jdbc.ProcedureParamCell;
import com.northpool.resources.sql.jdbc.SQLTransformer;
import com.northpool.resources.type.Type;

public interface SQLGenericDao {
	
    public <T> List   <T> queryBySql (final String sql, final Object[] objs,final Type[] types,final Map<String,Type> returnTypes,
        final Integer firstResult, final Integer maxResults, final Integer fetchSize,final SQLTransformer<T> transformer) throws DataAccessException;
    
    public <T> Scroll <T> scrollBySql(final String sql, final Object[] objs,final Type[] types,final Map<String,Type> returnTypes, 
        final Integer firstResult,final Integer maxResults, final Integer fetchSize,final SQLTransformer<T> transformer);
	
    public Long getCountBySql(String querySql, Object[] objs, Type[] types);
    
    public Object[] excuteProcedure(String procedureName, ProcedureParamCell... params);
    
    public void doBatchExecuteSql(final String sql,final List<Object[]> datas,final Type[] types,final Integer batchSize) throws DataAccessException;
    
    public void doExecuteSql(final String sql, final Object[] datas, final Type[] types) throws DataAccessException;
}
