package com.northpool.resources.sql;

import java.util.List;
import java.util.Map;

import com.northpool.resources.type.Type;

public class SQLParameter{
	String sql;
	Object[] values;
	Map<String,Type> returnTypeMap;
	Type[] types;
	public SQLParameter(String sql,List<Object> values,List<Type> types,Map<String,Type> returnTypeMap){
		this.sql = sql;
		this.values = values.toArray(new Object[values.size()]);
		this.types = types.toArray(new Type[types.size()]);
		this.returnTypeMap = returnTypeMap;
	}
	public String getSql() {
		return sql;
	}
	
	public Type[] getTypes(){
	    return types;
	}
	
	public Object[] getValues() {
		return values;
	}
	public Map<String,Type> getReturnTypeMap(){
		return this.returnTypeMap;
	}
	
}