package com.northpool.resources.sql;

import com.northpool.commons.util.StringUtility;
import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datatable.FieldDecoder;
import com.northpool.resources.datatable.db.DBTable;
import com.northpool.resources.datatablebuilder.db.IDBTableBuilder;
import com.northpool.resources.dialect.db.SQLDialect;
import com.northpool.resources.dialect.function.Function.FUNCTION_PART_STRUCTURE;
import com.northpool.resources.dialect.function.sql.SQLFunction;
import com.northpool.resources.sql.QueryFilterToSQL.WherePartSQL;
import com.northpool.resources.type.Type;
import org.apache.commons.lang3.StringUtils;

import java.util.*;

public class SQLQueryEngineImpl implements SQLQueryEngine {
	
    DBTable table;
    public static final String SELECT_ALL = "*";
    public static final String AS_SEPARATOR = " as ";
    SQLDialect dialect;
    FieldDecoder fieldDecoder;
    QueryFilter queryFilter;
    String nativeSQL;
    Map<String, Type> returnTypeMap = new LinkedHashMap<String, Type>();
    List<String> aliasFieldElement = new ArrayList<String>();
    List<String> dbFieldNamesElement = new ArrayList<String>();
    QueryFilterToSQL queryFilterToSQL;
    String mainSqlPart = null;
    private int suffix = 0;
    public static final String WHERE_FILTER = "{whereFilter}";
    public static final String ORDER_BY_CLAUSE = "{order}";
    List<Object> parameterList;
    List<Type> parameterTypeList;

	public SQLQueryEngineImpl(DBTable table,QueryFilter queryFilter) throws Exception{
 		this.table = table;
		this.dialect = SQLDialect.getSQLDialect(table.getDbDataSource().getDataSourceType());
		this.fieldDecoder = table.fieldDecoder();
		this.queryFilterToSQL = new QueryFilterToSQL(queryFilter, dialect,table.fieldsTypeMap(),this.fieldDecoder);
		this.queryFilter = queryFilter;
	}
	
	
	
	public SQLQueryEngineImpl(String mainSqlPart,DATA_SOURCE_TYPE type,QueryFilter queryFilter,Map<String,Type> typeMap) throws Exception{
		this.mainSqlPart = mainSqlPart;
		this.dialect = SQLDialect.getSQLDialect(type);
		this.fieldDecoder = new FieldDecoder(){
			@Override
			public String decode(String field) {
				// TODO Auto-generated method stub
				return field;
			}

			@Override
			public Type getType(String field) throws Exception {
				return typeMap.get(field);
			}

			@Override
			public String getExceptionNameMark() {
				// TODO Auto-generated method stub
				return new StringBuilder("SQL语句:" + mainSqlPart).toString();
			}
		};
		this.returnTypeMap = typeMap;
		this.queryFilterToSQL = new QueryFilterToSQL(queryFilter, dialect,new HashMap<String,Type>(),this.fieldDecoder);
	}
	
	protected void addField(String alias,String fieldInDB,Type returnType){
		this.dbFieldNamesElement.add(fieldInDB);
		this.aliasFieldElement.add(alias);
		returnTypeMap.put(alias, returnType);
	}
	
	
	
	
	
	
	protected void translateSelectPart(List<String> selectPart){
		//Map<String,Type> returnTypeMap = new HashMap<String,Type>();
		if(selectPart.isEmpty()){
			selectPart = Arrays.asList(table.getFieldNameArr());
		}
		/*if(selectPart.isEmpty()){
			//如果没有指定输出字段,则取所有的字段
			Set<Map.Entry<String,IDBField>> set = table.getFieldsMap().entrySet();
			for(Map.Entry<String,IDBField> entry : set){
				IDBField field = entry.getValue();
				Type returnType = field.getType();
				String fieldInDB = field.getOriginFieldName();
				String alias = field.getFieldName();
				this.addField(alias, fieldInDB, returnType);
			}
		}*/
		//List<String> fieldList = new ArrayList<String>();
		
		for(String field : selectPart){
			String fieldInDB = null;
			String alias = null;
			String[] aliasInfo = this.getAlias(field);
			if(aliasInfo.length == 1){
				field = aliasInfo[0];
				alias = field;
			}else{
				field = aliasInfo[0];
				alias = aliasInfo[1];
			}
			String[] fieldInfo = StringUtility.getFunctionInfo(field);
			if(fieldInfo == null){
				fieldInDB = fieldDecoder.decode(field);
				if(fieldInDB == null){
					throw new RuntimeException(table.getId() + "找不到字段" + field);
				}
				//fieldList.add(fieldInDB);
				Type returnType;
				try{
					returnType = fieldDecoder.getType(field);
				}catch(Exception e){
					e.printStackTrace();
					returnType = null;
				}
				Type type = this.queryFilter.getReturnTypeMap().get(alias);
				if(type == null){
				    type = returnType;
				}
				this.addField(alias, fieldInDB, type);
			}else{
				//fieldInDB = fieldInfo[0];
				String functionName = fieldInfo[0];
				SQLFunction function = dialect.getFunction(functionName);
				if(function == null){
					throw new RuntimeException(table.getDbDataSource().getDataSourceType().name() + " 没有找到函数" + functionName);
				}
				this.translateFunction(alias, fieldInfo, function);
			}
		}
		
		
	}
	
	protected String[] getAlias(String field){
		String[] part = field.split(AS_SEPARATOR);
		if(part.length == 1){
			part = field.split(AS_SEPARATOR.toUpperCase());
		}
		return part;
	}
	
	
	
	protected void translateFunction(String alias,String[] fieldInfo,SQLFunction function){
		List<String> parameterList = new ArrayList<String>();
		if(fieldInfo[1] != null){
			String[] parameters = fieldInfo[1].split(",");
			for(String info : parameters){
				parameterList.add(this.processPartStructure(info,function));
			}
		}
		String functionSqlExpression = null;
		try {
			functionSqlExpression = function.render(parameterList);
		} catch (Exception e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
			throw new RuntimeException("这里基本不可能出错,throw是为了满足接口而已");
		}
		this.addField(alias,functionSqlExpression , function.getReturnType());
	//	return function.render(parameterList);
	}
	
	
	private Boolean isTable(String structure){
		if(structure.toLowerCase().indexOf("from") != -1 && structure.toLowerCase().indexOf("select") !=-1){
			return false;
		}
		return true;
		
	}
	
	protected String getSqlSelectElement(String structure,List<String> dbFieldNamesElement,List<String> aliasFieldElement,int suffix){
		String sql;
		Select select = new Select(dialect);
		if(isTable(structure)){
			String alias = structure.substring(0,1) + "_" + suffix;
			select.setFromClause(structure, alias);
			SelectFragment selectFragment = new SelectFragment(dialect);
			selectFragment.addColumns(alias, dbFieldNamesElement, aliasFieldElement);
			String selectClause = selectFragment.toFragmentString();
			select.setSelectClause(selectClause.substring(1, selectClause.length()));
		}else{
			int fromIndex = structure.toLowerCase().lastIndexOf("from");
			String alias = structure.substring(fromIndex,structure.length());
			alias = alias.trim().substring(0,1) + "_" + suffix;
			select.setFromClause(new StringBuilder("(").append(structure).append(")").toString(), alias);
			SelectFragment selectFragment = new SelectFragment(dialect);
			selectFragment.addColumns(alias, dbFieldNamesElement, aliasFieldElement);
			String selectClause = selectFragment.toFragmentString();
			select.setSelectClause(selectClause.substring(1, selectClause.length()));
	
		}
		select.setWhereClause(WHERE_FILTER);
		//select.setOrderByClause(ORDER_BY_CLAUSE);
		sql =  select.toStatementString();
		return sql;
		
	}
	
	protected void check(DBTable table,QueryFilter queryFilter){
		
	}
	@Override
	public SQLParameter toNativeSQL(){
		if(table != null){
			//这里以后需要加入queryFilter所使用的字段是否在table中的判断代码
			this.check(table, queryFilter);
			String tableName = this.table.getTablename();
		
			String schema = ((IDBTableBuilder)this.table.getTableBuilder()).getSchema();
			this.translateSelectPart(this.queryFilter.getOutputFieldNames());
			this.mainSqlPart = this.getSqlSelectElement(this.dialect.processTableNameAndSchema(schema, tableName), dbFieldNamesElement, aliasFieldElement, suffix);
			
		}else{
			if(this.returnTypeMap.isEmpty()){
				throw new RuntimeException("returnTypeMap不能为空");
			}
		}
		WherePartSQL wherePart = this.queryFilterToSQL.toWherePartSQL();
		if(wherePart != null){
			this.nativeSQL = this.mainSqlPart.replace(WHERE_FILTER, new StringBuilder(" where ").append(wherePart.wherePart));
			this.parameterList = wherePart.values;
			this.parameterTypeList = wherePart.types;
		}else{
			this.nativeSQL = this.mainSqlPart.replace(WHERE_FILTER, "");
			this.parameterList = new ArrayList<Object>();
			this.parameterTypeList = new ArrayList<>();
		}
		SQLParameter sqlParameter = new SQLParameter(this.nativeSQL,this.parameterList,this.parameterTypeList,this.returnTypeMap);
		return sqlParameter;
		
	}
	
	/*protected SQLParameter buildSQLParameter(){
		SQLParameter sqlParameter = new SQLParameter(this.nativeSQL,this.parameterList,this.parameterTypeList,this.returnTypeMap);
		return sqlParameter;
	}*/
	
	protected String processPartStructure(String partStr,SQLFunction function){
		//先找这个字段是什么类型的
		FUNCTION_PART_STRUCTURE sps = function.partStructure(partStr);
		switch(sps){
			case parameter :
				return partStr;
			case verchar : 
				return partStr;
			case number : 
				return partStr;
			case column : 
				String fieldInDB = fieldDecoder.decode(partStr);
				if(fieldInDB == null){
					throw new RuntimeException(table.getId() + "找不到字段" + partStr);
				}
				return fieldInDB;
			
		}
		return null;
	}


}
