
package com.northpool.resources.sql;

import com.northpool.commons.util.StringUtility;
import com.northpool.resources.dialect.db.SQLDialect;

public class Select {

	private String selectClause;
	private String fromClause;
	private String whereClause;
	
	private String orderByClause;
	private String groupByClause;
	private String comment;
	public final SQLDialect dialect;

	private int guesstimatedBufferSize = 20;

	public Select(SQLDialect dialect) {
		this.dialect = dialect;
	}

	public String toStatementString() {
		StringBuilder buf = new StringBuilder(guesstimatedBufferSize);
		if (StringUtility.isNotEmpty(comment)) {
			buf.append("/* ").append(comment).append(" */ ");
		}

		buf.append("select ").append(selectClause).append(" from ").append(fromClause);

		if (StringUtility.isNotEmpty(whereClause)) {
		
			if (StringUtility.isNotEmpty(whereClause)) {
				buf.append(whereClause);
			}
		}

		if (StringUtility.isNotEmpty(groupByClause)) {
			buf.append(" group by ").append(groupByClause);
		}

		if (StringUtility.isNotEmpty(orderByClause)) {
			buf.append(orderByClause);
		}

		/*
		 * if (lockOptions.getLockMode()!=LockMode.NONE) { buf.append(
		 * dialect.getForUpdateString(lockOptions) ); }
		 */

		return buf.toString();
	}

	public Select setFromClause(String fromClause) {
		this.fromClause = fromClause;
		this.guesstimatedBufferSize += fromClause.length();
		return this;
	}

	public Select setFromClause(String tableName, String alias) {
		String schema = "";
		if (tableName.indexOf(".") != -1){
			String[] splits = tableName.split("\\.");
			schema = splits[0];
			tableName = splits[1];
		}
		if(dialect.markForTableNameAndColumnName()){
			StringBuilder builder = new StringBuilder("\"");
			if (!"".equals(schema)){
				builder.append(schema).append("\".\"");
			}
			builder.append(tableName).append("\" ").append(alias);
			this.fromClause = builder.toString();
		}else{
			this.fromClause = new StringBuilder(tableName).append(" ").append(alias).toString(); 
		}
		this.guesstimatedBufferSize += fromClause.length();
		return this;
	}


	public Select setOrderByClause(String orderByClause) {
		this.orderByClause = orderByClause;
		this.guesstimatedBufferSize += orderByClause.length();
		return this;
	}

	public Select setGroupByClause(String groupByClause) {
		this.groupByClause = groupByClause;
		this.guesstimatedBufferSize += groupByClause.length();
		return this;
	}

	public Select setSelectClause(String selectClause) {
		this.selectClause = selectClause;
		this.guesstimatedBufferSize += selectClause.length();
		return this;
	}

	public Select setWhereClause(String whereClause) {
		this.whereClause = whereClause;
		this.guesstimatedBufferSize += whereClause.length();
		return this;
	}

	public Select setComment(String comment) {
		this.comment = comment;
		this.guesstimatedBufferSize += comment.length();
		return this;
	}

}
