
package com.northpool.resources.sql;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

import com.northpool.resources.dialect.db.SQLDialect;






public class SelectFragment {
	private List<String> columns = new ArrayList<String>();
	//private List aliases = new ArrayList();
	private List<String> columnAliases = new ArrayList<String>();
	private String extraSelectList;
	private String[] usedAliases;
	public static final String TEMPLATE = "$PlaceHolder$";
	private SQLDialect dialect;
	
	public SelectFragment(SQLDialect dialect) {
		this.dialect = dialect;
	}

	public List<String> getColumns() {
		return columns;
	}

	public String getExtraSelectList() {
		return extraSelectList;
	}

	public SelectFragment setUsedAliases(String[] aliases) {
		usedAliases = aliases;
		return this;
	}
	
	public SelectFragment setExtraSelectList(String extraSelectList) {
		this.extraSelectList = extraSelectList;
		return this;
	}
	




	public SelectFragment addColumn(String columnName) {
		addColumn(null, columnName);
		return this;
	}
	
	public String qualify(String prefix, String name) {
		if (name == null || prefix == null) {
			throw new NullPointerException();
		}
		if(this.dialect.markForTableNameAndColumnName()){
			return new StringBuilder(prefix.length() + name.length() + 3).append(prefix).append(".\"").append(name).append("\"").toString();
		}else{
			return new StringBuilder(prefix.length() + name.length() + 3).append(prefix).append(".").append(name).toString();
		}
	}

	public SelectFragment addColumns(String[] columnNames) {
		for (int i = 0; i < columnNames.length; i ++){
			addColumn( columnNames[i] );
		}
		return this;
	}

	public SelectFragment addColumn(String tableAlias, String columnName) {
		return addColumn(tableAlias, columnName, columnName);
	}

	public SelectFragment addColumn(String tableAlias, String columnName, String columnAlias) {
		columns.add( this.qualify(tableAlias, columnName) );
		columnAliases.add(columnAlias);
		return this;
	}

	public SelectFragment addColumns(String tableAlias, String[] columnNames) {
		for (int i = 0; i < columnNames.length; i ++) {
			addColumn( tableAlias, columnNames[i] );
		}
		return this;
	}

	public SelectFragment addColumns(String tableAlias, List<String> columnNames, List<String> columnAliases) {
		for (int i = 0; i < columnNames.size(); i++) {
			if (columnNames.get(i) != null){
				addColumn(tableAlias, columnNames.get(i), columnAliases.get(i));
			}
		}
		return this;
	}

	
	
	
	public String toFragmentString() {
		StringBuilder buf = new StringBuilder(columns.size() * 10);
		Iterator<String> iter = columns.iterator();
		Iterator<String> columnAliasIter = columnAliases.iterator();
		HashSet<String> columnsUnique = new HashSet<String>();
		if (usedAliases != null) {
			columnsUnique.addAll(Arrays.asList(usedAliases));
		}
		while (iter.hasNext()) {
			String column = (String) iter.next();
			String columnAlias = (String) columnAliasIter.next();

			if (columnsUnique.add(columnAlias)) {
				buf.append(", ").append(column).append(" as ");
				if(this.dialect.markForTableNameAndColumnName()){
					buf.append("\"").append(columnAlias).append("\"");
				}else{
					buf.append(columnAlias);
				}
				/*
				 * if (suffix == null) { buf.append(columnAlias); } else {
				 * buf.append(
				 * this.toAliasString(suffix).toAliasString(columnAlias) ); }
				 */
			}
		}
		if (extraSelectList != null) {
			buf.append(", ").append(extraSelectList);
		}
		return buf.toString();
	}
	
	

}
