package com.northpool.resources.sql.jdbc;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.northpool.exception.UException;
import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datatable.Scroll;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.dialect.db.SQLDialect;
import com.northpool.resources.type.Type;

public abstract class AbstractsSQLTransformer<T> {
	
	protected Map<String, Type> createTypeMap(final ResultSet rs,Map<String, Type> typeMap,final SQLDialect dialect) throws SQLException{
		ResultSetMetaData rsmd = rs.getMetaData();
		int columnCount = rsmd.getColumnCount();
		if(typeMap == null){
			typeMap = new HashMap<String, Type>();
		}
		for (int i = 1; i <= columnCount; i++) {
			String type = rsmd.getColumnTypeName(i);
			String name = rsmd.getColumnLabel(i);
			
			if(typeMap.get(name) == null){
				Type t = dialect.getTypeByName(type);
				typeMap.put(name, t);
			}
		}	
		return typeMap;
	}
	
	
	abstract protected ResultSetMapping<T> getMapping();
	
	public List<T> extractData(final SQLDialect dialect,final ResultSet rs, Map<String,Type> typeMap) throws SQLException {
		List<T> iList = new ArrayList<T>();
		ResultSetMapping<T> mapping = this.getMapping();
		typeMap = this.createTypeMap(rs, typeMap,dialect);
		
		while(rs.next()){
			T t = mapping.mapping(rs,typeMap,dialect);
			iList.add(t);
		}
		return iList;	
	}
	
	
	
    public Scroll<T> extractDataScroll(SQLDialect dialect, ResultSet rs, Map<String, Type> typeMap, PreparedStatementCreator psc, DbDataSource dbDataSource,Connection con, PreparedStatement ps) throws SQLException  {
        
        
        ResultSetMapping<T> mapping = this.getMapping();
        typeMap = this.createTypeMap(rs, typeMap,dialect);
        final Map<String, Type> _typeMap = typeMap;
        Scroll<T> scroll = new Scroll<T>(){
            @Override
            public boolean hasNext()  {
                try {
                    return rs.next();
                } catch (SQLException e) {
                    // TODO Auto-generated catch block
                    UException.printStackTrace(e);
                    throw new DataAccessException(e);
                }
            }

            @Override
            public T next()  {
                T t = mapping.mapping(rs,_typeMap,dialect);
                return t;
            }

            @Override
            public void close() throws IOException {
                // TODO Auto-generated method stub
                /*if (psc instanceof ParameterDisposer) {
                    ((ParameterDisposer) psc).cleanupParameters();
                }*/
                AbstractsSQLCell.closeStatement(ps);
                AbstractsSQLCell.releaseConnection(con, dbDataSource);
            } 
        };
        
        return scroll;
    }
	
	
}
