package com.northpool.resources.sql.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Map;

import com.northpool.resources.dialect.db.SQLDialect;
import com.northpool.resources.type.Type;

public class ArraySQLTransformer extends AbstractsSQLTransformer<Object[]> implements SQLTransformer<Object[]>{

	@Override
	protected ResultSetMapping<Object[]> getMapping() {
		
		return new ResultSetMapping<Object[]>(){
			
			@Override
			public Object[] mapping(ResultSet rs, Map<String, Type> typeMap,final SQLDialect dialect) {
				// TODO Auto-generated method stub
				ResultSetMetaData rsmd;
				int systemFiledNum = 0;
				try {
					rsmd = rs.getMetaData();
					int columnCount = rsmd.getColumnCount();
					Object[] values = new Object[columnCount];
					for (int i = 1; i <= columnCount; i++) {
						String name = rsmd.getColumnLabel(i);
						if(dialect.isSystemMarkFiled(name)){
						    systemFiledNum++;
						    continue;
						}
						Type type = typeMap.get(name);
						Object value = null;
						value = type.getValueByResultSet(rs, i);
						values[i - 1 - systemFiledNum] = value;
					}
					if(systemFiledNum == 0){
					    return values;
					}else{
					    Object[] valuesNew = new Object[columnCount - systemFiledNum];
					    System.arraycopy(values, 0, valuesNew, 0, columnCount - systemFiledNum);
					    return valuesNew;
					}
				} catch (Exception e) {
					e.printStackTrace();
					throw new RuntimeException(e);
				}
			}
			
		};
	}


  
	
	
	
	
	
}
