package com.northpool.resources.sql.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.HashMap;
import java.util.Map;


import com.northpool.resources.dialect.db.SQLDialect;
import com.northpool.resources.type.Type;

public class MapSQLTransformer extends AbstractsSQLTransformer<Map<String,?>> implements SQLTransformer<Map<String,?>>{

	

	@Override
	protected ResultSetMapping<Map<String,?>> getMapping() {
		
		return new ResultSetMapping<Map<String,?>>(){

			@Override
			public Map<String, ?> mapping(ResultSet rs, Map<String, Type> typeMap,final SQLDialect dialect) {
				Map<String,Object> returnValue = new HashMap<String,Object>();
				ResultSetMetaData rsmd;
				try {
					rsmd = rs.getMetaData();
					int columnCount = rsmd.getColumnCount();
					for (int i = 1; i <= columnCount; i++) {
						String name = rsmd.getColumnLabel(i);
						if(dialect.isSystemMarkFiled(name)){
						    continue;
						}
						Type type = typeMap.get(name);
						Object value = null;
						value = type.getValueByResultSet(rs, i);
						returnValue.put(name,value);
					}
					return returnValue;
				} catch (Exception e) {
					e.printStackTrace();
					throw new RuntimeException(e);
				}
			}
			
		};
	}

   
	
	
	
	
	
}
