/**
　 * <p>Title: IDSQLTransformer.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年10月19日
　 * @version 1.0
*/
package com.northpool.resources.sql.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.Map;

import com.northpool.resources.dialect.db.SQLDialect;
import com.northpool.resources.type.Type;

/**
 * @author matt
 *
 */
public class OneFiledSQLTransformer  extends AbstractsSQLTransformer<Object> implements SQLTransformer<Object> {

   
    
    public OneFiledSQLTransformer(){
       
    }
    
    @Override
    protected ResultSetMapping<Object> getMapping() {
        // TODO Auto-generated method stub
        return new ResultSetMapping<Object>(){
            @Override
            public Object mapping(ResultSet rs, Map<String, Type> typeMap,final SQLDialect dialect) {
                // TODO Auto-generated method stub
                ResultSetMetaData rsmd;
                try {
                    rsmd = rs.getMetaData();
                    String name = rsmd.getColumnLabel(1);
                    Type type = typeMap.get(name);
                    Object value = null;
                    value = type.getValueByResultSet(rs, 1);
                    return value;
                } catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
            
        };
    }

}
