package com.northpool.resources.sql.jdbc;

import java.util.Iterator;
import java.util.List;
import java.util.Map;

import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datatable.Scroll;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.dialect.db.SQLDialect;
import com.northpool.resources.sql.SQLGenericDao;
import com.northpool.resources.type.Type;

public class SQLGenericDaoImpl implements SQLGenericDao {

    protected DbDataSource dbDataSource;

    protected SQLDialect dialect;

    // protected DataSource dataSource;

    public SQLGenericDaoImpl(DbDataSource dbDataSource) {
        /*DataSource dataSource = Transactions.getThreadDataSource(dbDataSource); 
        if(dataSource == null){
            dataSource = JDBCPoolManager.getInstance().getPool(dbDataSource);
        }*/
        // this.dataSource = dataSource;
        this.dbDataSource = dbDataSource;
        this.dialect = SQLDialect.getSQLDialect(dbDataSource.getDataSourceType());

        // this.jdbcTemplate = new JdbcTemplate(dataSource);

    }

    private <T> SQLQuery<T> SQLQuery(final String sql) {

        return new SQLQuery<>(this.dbDataSource, dialect, sql);

    }

    private SQLUpdate SQLUpdate(String sql) {

        return new SQLUpdate(this.dbDataSource, dialect, sql);

    }

    private <T> SQLQuery<T> createSQLQuery(final String sql, final Object[] args, final Type[] types,
        final Integer firstResult, final Integer maxResults, final Map<String, Type> returnType,
        final SQLTransformer<T> transformer) throws DataAccessException {

        SQLQuery<T> query = this.SQLQuery(sql);
        query.setResultTransformer(transformer);

        query.addScalar(returnType);
        if (args != null) {
            Type[] inTypes;
            if (types == null) {
                inTypes = this.guessType(args);
            } else {
                inTypes = types;
            }
            query.setInputTypes(inTypes);
            query.setParameters(args);
        }

        query.setFirstResult(firstResult).setMaxResults(maxResults);

        return query;
    }

    private Type[] guessType(Object[] args) {
        Type[] types = new Type[args.length];
        for (int i = 0; i < args.length; i++) {
            Object arg = args[i];
            Type t = this.dialect.getTypeByObject(arg);
            types[i] = t;
        }
        return types;

    }

    private SQLUpdate createSQLUpdate(final String sql, final Type[] types, final Integer batchSize) {
        SQLUpdate update = this.SQLUpdate(sql);
        update.setInputTypes(types);
        if (batchSize != null) {
            update.setBatchSize(batchSize);
        }
        return update;
    }

    public <T> List<T> queryBySql(final String sql, final Object[] objs, final Type[] types,
        final Map<String, Type> returnTypes, final Integer firstResult, final Integer maxResults,
        final Integer fetchSize, final SQLTransformer<T> transformer) throws DataAccessException {
        SQLQuery<T> query = this.createSQLQuery(sql, objs, types, firstResult, maxResults, returnTypes, transformer);
        query.setFetchSize(fetchSize);
        List<T> i = query.list();
        return i;
    }

    public <T> Scroll<T> scrollBySql(final String sql, final Object[] objs, final Type[] types,
        final Map<String, Type> returnTypes, final Integer firstResult, final Integer maxResults, final Integer fetchSize,
        final SQLTransformer<T> transformer) {
        // TODO Auto-generated method stub
        SQLQuery<T> query = this.createSQLQuery(sql, objs, types, firstResult, maxResults, returnTypes, transformer);
        query.setFetchSize(fetchSize);
        return query.scroll();
    }

    public Long getCountBySql(String querySql, Object[] objs, Type[] types) {
        // TODO Auto-generated method stub
        int orderByIndex = querySql.toUpperCase().indexOf(" ORDER BY ");

        if (orderByIndex != -1) {
            querySql = querySql.substring(0, orderByIndex);
        }
        String sql;
       
        sql = "select count(*) as count from (" + querySql + ") tmp_count_t";
       
        SQLQuery<Object> query = this.createSQLQuery(sql, objs, types, -1, -1, null, SQLTransformer.ONEFILED);

        List<Object> i = query.list();
        if(i.isEmpty()){
            return null;
        }
        
        return (Long)i.get(0);
    }

    public Object[] excuteProcedure(String procedureName, ProcedureParamCell... params) {
        // TODO Auto-generated method stub
        return null;
    }

    public void doBatchExecuteSql(final String sql, final List<Object[]> datas, final Type[] types,
        final Integer batchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        if(types == null){
            throw new DataAccessException("types参数不能为空");
        }
        
        
        UpdateDataScroll scroll = new UpdateDataScroll() {

            Iterator<Object[]> iterator = datas.iterator();

            @Override
            public boolean hasNext() {
                // TODO Auto-generated method stub
                return iterator.hasNext();
            }

            @Override
            public Object[] next() {
                // TODO Auto-generated method stub
                return iterator.next();
            }

            @Override
            public int size() {
                // TODO Auto-generated method stub
                return datas.size();
            }

        };
        this.doBatchExecuteSql(sql, types, scroll, batchSize);
    }

    protected void doBatchExecuteSql(final String sql, final Type[] types, final UpdateDataScroll scroll,
        final Integer batchSize) throws DataAccessException {
        // TODO Auto-generated method stub
        SQLUpdate update = this.createSQLUpdate(sql, types, batchSize);
        update.batchUpdate(scroll);
    }

    public void doExecuteSql(final String sql, final Object[] datas, final Type[] types) throws DataAccessException {
        Type[] typeArr = null;
        if(datas != null){
            if(types == null){
                typeArr = this.guessType(datas);
            }else{
                if(datas.length != types.length){
                    throw new DataAccessException("参数datas的长度必须和types的长度一致");
                }else{
                    typeArr = types;
                }
            }
        }
        
        
        SQLUpdate update = this.createSQLUpdate(sql, typeArr, null);
        update.update(datas);
    }

}
