package com.northpool.resources.sql.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;



import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datatable.Scroll;
import com.northpool.resources.dialect.db.SQLDialect;
import com.northpool.resources.sql.Transformer;
import com.northpool.resources.type.Type;

public interface SQLTransformer<T> extends Transformer<T> {
	
	
	public final static SQLTransformer<Map<String,?>> MAP = new MapSQLTransformer();
	
	public final static SQLTransformer<Object[]> ARRAY = new ArraySQLTransformer();
	
	public final static OneFiledSQLTransformer ONEFILED = new OneFiledSQLTransformer();
	
	
	
	public List<T> extractData(final SQLDialect dialect,final ResultSet rs,final Map<String,Type> typeMap) throws SQLException;
	
	public Scroll<T> extractDataScroll(final SQLDialect dialect,final ResultSet rs,final Map<String,Type> typeMap,final PreparedStatementCreator psc,final DbDataSource dataSource,final Connection con,final PreparedStatement ps) throws SQLException;
	
}
