package com.northpool.resources.sql.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.apache.commons.lang3.StringUtils;

import com.northpool.exception.UException;
import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.dialect.db.SQLDialect;
import com.northpool.resources.sql.Update;
import com.northpool.resources.type.Type;

public class SQLUpdate extends AbstractsSQLCell<Void> implements Update{ 
	
	protected int batchSize = 40;

	public SQLUpdate(DbDataSource dbDataSource, SQLDialect dialect,String sql)  {
		super(dbDataSource, dialect, sql);
		// TODO Auto-generated constructor stub
	}

	/*@Override
	public Update setResultTransformer(Transformer<?> transformer) {
		// TODO Auto-generated method stub
		this.transformer = (SQLTransformer<?>) transformer;
		return this;
	}*/
	
	protected void printSQL(Object[] args,Integer batchSize){
	    if(batchSize != null){
            logger.debug(this.sql);
            logger.debug("use parameters:" + StringUtils.join(args, ","));
	    }else{
	        logger.debug(this.sql);
	        logger.debug("use parameters size " + batchSize);
	    }
    }
	
	public void update(final Object[] args) throws DataAccessException {
	    
        try {
            this.execute((Connection con) ->{
                return this.prepareUpdateStatement(con);
            }, (PreparedStatement ps) ->{
                try {
                    if(args != null){
                        this.setValues(ps, args,this.inputTypes.toArray(new Type[this.inputTypes.size()]));
                    }
                    ps.execute();
                } catch (Exception e) {
                    Boolean isAutoCommit = ps.getConnection().getAutoCommit();
                    if(!isAutoCommit){
                        ps.getConnection().rollback();
                    }
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                
                return 1;
            });
        } catch (SQLException e) {
            // TODO Auto-generated catch block
            throw new DataAccessException(e);
        }
        
	}
	

	@Override
	public void batchUpdate(final UpdateDataScroll scroll) throws DataAccessException {
		
        try {
            this.execute((Connection con) ->{
            	return this.prepareUpdateStatement(con);
            }, (PreparedStatement ps) ->{
            	try {
            		int index = 0;
            		while(scroll.hasNext()){
            			Object[] args = scroll.next();
            			this.setValues(ps, args,this.inputTypes.toArray(new Type[this.inputTypes.size()]));
            			ps.addBatch();
            			if ((index + 1) % this.batchSize == 0) {
            		        ps.executeBatch();
            		    }
            			index ++;
            		}
            		if (scroll.size() % batchSize != 0) {
            		    ps.executeBatch();
            		}
            	
            	} catch (Exception e) {
            		Boolean isAutoCommit = ps.getConnection().getAutoCommit();
            		if(!isAutoCommit){
            			ps.getConnection().rollback();
            		}
            		UException.printStackTrace(e);
            		throw new SQLException(e);
            	}
            	
            	return 1;
            });
        } catch (SQLException e) {
            // TODO Auto-generated catch block
            throw new DataAccessException(e);
        }
        
	}

	
	@Override
	public Update setBatchSize(int batchSize) {
		// TODO Auto-generated method stub
		this.batchSize = batchSize;
		return this;
	}

	
	protected final PreparedStatement prepareUpdateStatement(Connection connection) throws SQLException{
		
		PreparedStatement preparedStatement = connection.prepareStatement(this.sql);
		//如果没有事务，则设置自动提交
		if(connection.getTransactionIsolation() == Connection.TRANSACTION_NONE){
			connection.setAutoCommit(true);
		}
		
		return preparedStatement;
	}

	


}
