package com.northpool.resources.type;

import com.kingbase8.util.KBobject;
import com.northpool.commons.type.ConverterType;
import com.northpool.resources.Constants.SPATIAL_TYPE;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.mgeom.MCoordinate;
import com.northpool.spatial.mgeom.MGeometry;
import com.northpool.spatial.mgeom.MGeometryFactory;
import com.northpool.spatial.postgresql.EwkbDecoder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import com.kinggis.*;

import java.io.ByteArrayInputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;


public class TypeKingbaseGeometry implements Type,GeometryType {
	
	public static TypeKingbaseGeometry INSTANCE = new TypeKingbaseGeometry();

	protected String name = GeometryType.NAME;
	protected Class<?> clazz = GeoBuffer.class;
	protected String typeName = "KinggisGeometry";
	
	@Override
	public String name() {
		// TODO Auto-generated method stub
		return name;
	}

	@Override
	public Class<?> getJavaClass() {
		// TODO Auto-generated method stub
		return clazz;
	}

	@Override
	public Object getValueByResultSet(ResultSet rs, int index) throws Exception {
		// TODO Auto-generated method stub
		ByteArrayInputStream is = (ByteArrayInputStream) rs.getBinaryStream(index);
		if(is == null){
			return null;
		}
		return EwkbDecoder.decoder().toGeoBuffer(is);
	}

	@Override
	public void preparedStatementSetValue(PreparedStatement ps, Object o, int index) throws Exception {
		// TODO Auto-generated method stub
		if(o instanceof Geometry){
			Object pg = conv2DBGeometry((Geometry)o);
			ps.setObject(index, pg);
		}
		if(o instanceof GeoBuffer){
			//临时这样写
			GeoBuffer geo = (GeoBuffer)o;
			Object pg = conv2DBGeometry((Geometry)geo.toGeometry());
			ps.setObject(index, pg);
		}
		if(o instanceof byte[]){
		    KBobject po = new KBobject();
	        po.setType(this.name);
	        po.setValue(new String((byte[])o));
	        ps.setObject(index, po);
		}
		if(o instanceof String){
            KBobject po = new KBobject();
            po.setType(this.name);
            po.setValue((String)o);
            ps.setObject(index, po);
		}
	}
	
	private Geometry forceEmptyToGeometryCollection(Geometry jtsGeom) {
        Geometry forced = jtsGeom;
        if (forced.isEmpty()) {
            GeometryFactory factory = jtsGeom.getFactory();
            if (factory == null) {
                factory = new MGeometryFactory();
            }
            forced = factory.createGeometryCollection(null);
            forced.setSRID(jtsGeom.getSRID());
        }
        return forced;
    }
	

    private Point[] toPoints(Coordinate[] coordinates) {
        Point[] points = new Point[coordinates.length];
        for (int i = 0; i < coordinates.length; i++) {
            Coordinate c = coordinates[i];
            Point pt;
            if (Double.isNaN(c.z)) {
                pt = new Point(c.x, c.y);
            } else {
                pt = new Point(c.x, c.y, c.z);
            }
            if (c instanceof MCoordinate) {
                MCoordinate mc = (MCoordinate) c;
                if (!Double.isNaN(mc.m)) {
                    pt.setM(mc.m);
                }
            }
            points[i] = pt;
        }
        return points;
    }
	 
	protected Object conv2DBGeometry(Geometry jtsGeom){
		com.kinggis.Geometry geom = null;
		jtsGeom = forceEmptyToGeometryCollection(jtsGeom);
		if (jtsGeom instanceof org.locationtech.jts.geom.Point) {
			geom = convertJTSPoint((org.locationtech.jts.geom.Point) jtsGeom);
		} else if (jtsGeom instanceof org.locationtech.jts.geom.LineString) {
			geom = convertJTSLineString((org.locationtech.jts.geom.LineString) jtsGeom);
		} else if (jtsGeom instanceof org.locationtech.jts.geom.MultiLineString) {
			geom = convertJTSMultiLineString((org.locationtech.jts.geom.MultiLineString) jtsGeom);
		} else if (jtsGeom instanceof org.locationtech.jts.geom.Polygon) {
			geom = convertJTSPolygon((org.locationtech.jts.geom.Polygon) jtsGeom);
		} else if (jtsGeom instanceof org.locationtech.jts.geom.MultiPoint) {
			geom = convertJTSMultiPoint((org.locationtech.jts.geom.MultiPoint) jtsGeom);
		} else if (jtsGeom instanceof org.locationtech.jts.geom.MultiPolygon) {
			geom = convertJTSMultiPolygon((org.locationtech.jts.geom.MultiPolygon) jtsGeom);
		} else if (jtsGeom instanceof org.locationtech.jts.geom.GeometryCollection) {
			geom = convertJTSGeometryCollection((org.locationtech.jts.geom.GeometryCollection) jtsGeom);
		}

		if (geom != null){
			return new KBgeometry(geom);
		}else{
			throw new UnsupportedOperationException(
					"Conversion of " + jtsGeom.getClass().getSimpleName() + " to PGgeometry not supported");
	
		}
	}
	
	private LinearRing convertJTSLineStringToLinearRing(
            org.locationtech.jts.geom.LineString lineString) {
        LinearRing lr = new LinearRing(toPoints(lineString
                .getCoordinates()));
        lr.setSrid(lineString.getSRID());
        return lr;
    }
	
	private GeometryCollection convertJTSGeometryCollection(
            org.locationtech.jts.geom.GeometryCollection collection) {
        Geometry currentGeom;
        com.kinggis.Geometry[] pgCollections = new com.kinggis.Geometry[collection
                .getNumGeometries()];
        for (int i = 0; i < pgCollections.length; i++) {
            currentGeom = collection.getGeometryN(i);
            currentGeom = forceEmptyToGeometryCollection(currentGeom);
            if (currentGeom.getClass() == org.locationtech.jts.geom.LineString.class) {
                pgCollections[i] = convertJTSLineString((org.locationtech.jts.geom.LineString) currentGeom);
            } else if (currentGeom.getClass() == org.locationtech.jts.geom.LinearRing.class) {
                pgCollections[i] = convertJTSLineStringToLinearRing((org.locationtech.jts.geom.LinearRing) currentGeom);
            } else if (currentGeom.getClass() == org.locationtech.jts.geom.MultiLineString.class) {
                pgCollections[i] = convertJTSMultiLineString((org.locationtech.jts.geom.MultiLineString) currentGeom);
            } else if (currentGeom.getClass() == org.locationtech.jts.geom.MultiPoint.class) {
                pgCollections[i] = convertJTSMultiPoint((org.locationtech.jts.geom.MultiPoint) currentGeom);
            } else if (currentGeom.getClass() == org.locationtech.jts.geom.MultiPolygon.class) {
                pgCollections[i] = convertJTSMultiPolygon((org.locationtech.jts.geom.MultiPolygon) currentGeom);
            } else if (currentGeom.getClass() == org.locationtech.jts.geom.Point.class) {
                pgCollections[i] = convertJTSPoint((org.locationtech.jts.geom.Point) currentGeom);
            } else if (currentGeom.getClass() == org.locationtech.jts.geom.Polygon.class) {
                pgCollections[i] = convertJTSPolygon((org.locationtech.jts.geom.Polygon) currentGeom);
            } else if (currentGeom.getClass() == org.locationtech.jts.geom.GeometryCollection.class) {
                pgCollections[i] = convertJTSGeometryCollection((org.locationtech.jts.geom.GeometryCollection) currentGeom);
            }
        }
        GeometryCollection gc = new GeometryCollection(pgCollections);
        gc.setSrid(collection.getSRID());
        return gc;
    }
	
	private MultiPolygon convertJTSMultiPolygon(org.locationtech.jts.geom.MultiPolygon multiPolygon) {
		Polygon[] pgPolygons = new Polygon[multiPolygon.getNumGeometries()];
		for (int i = 0; i < pgPolygons.length; i++) {
			pgPolygons[i] = convertJTSPolygon((org.locationtech.jts.geom.Polygon) multiPolygon.getGeometryN(i));
		}
		MultiPolygon mpg = new MultiPolygon(pgPolygons);
		mpg.setSrid(multiPolygon.getSRID());
		return mpg;
	}

	
	private MultiPoint convertJTSMultiPoint(
            org.locationtech.jts.geom.MultiPoint multiPoint) {
        Point[] pgPoints = new Point[multiPoint.getNumGeometries()];
        for (int i = 0; i < pgPoints.length; i++) {
            pgPoints[i] = convertJTSPoint((org.locationtech.jts.geom.Point) multiPoint
                    .getGeometryN(i));
        }
        MultiPoint mp = new MultiPoint(pgPoints);
        mp.setSrid(multiPoint.getSRID());
        return mp;
    }
	
	private Polygon convertJTSPolygon(
            org.locationtech.jts.geom.Polygon jtsPolygon) {
        int numRings = jtsPolygon.getNumInteriorRing();
        LinearRing[] rings = new LinearRing[numRings + 1];
        rings[0] = convertJTSLineStringToLinearRing(jtsPolygon
                .getExteriorRing());
        for (int i = 0; i < numRings; i++) {
            rings[i + 1] = convertJTSLineStringToLinearRing(jtsPolygon
                    .getInteriorRingN(i));
        }
        Polygon polygon = new Polygon(rings);
        polygon.setSrid(jtsPolygon.getSRID());
        return polygon;
    }
	
	private LineString convertJTSLineString(
            org.locationtech.jts.geom.LineString string) {
        LineString ls = new LineString(toPoints(string
                .getCoordinates()));
        if (string instanceof MGeometry) {
            ls.haveMeasure = true;
        }
        ls.setSrid(string.getSRID());
        return ls;
    }
	
	private Point convertJTSPoint(org.locationtech.jts.geom.Point point) {
        Point pgPoint = new Point();
        pgPoint.srid = point.getSRID();
        pgPoint.x = point.getX();
        pgPoint.y = point.getY();
        Coordinate coordinate = point.getCoordinate();
        if (Double.isNaN(coordinate.z)) {
            pgPoint.dimension = 2;
        } else {
            pgPoint.z = coordinate.z;
            pgPoint.dimension = 3;
        }
        pgPoint.haveMeasure = false;
        if (coordinate instanceof MCoordinate && !Double.isNaN(((MCoordinate) coordinate).m)) {
            pgPoint.m = ((MCoordinate) coordinate).m;
            pgPoint.haveMeasure = true;
        }
        return pgPoint;
    }
	
	private MultiLineString convertJTSMultiLineString(
            org.locationtech.jts.geom.MultiLineString string) {
        LineString[] lines = new LineString[string
                .getNumGeometries()];
        for (int i = 0; i < string.getNumGeometries(); i++) {
            lines[i] = new LineString(toPoints(string.getGeometryN(
                    i).getCoordinates()));
        }
        MultiLineString mls = new MultiLineString(lines);
        if (string instanceof MGeometry) {
            mls.haveMeasure = true;
        }
        mls.setSrid(string.getSRID());
        return mls;
    }

	@Override
	public Object strToType(String str) throws Exception {
		// TODO Auto-generated method stub
	    if(str == null || "".equals(str)|| "null".equalsIgnoreCase(str)){
            return null;
        }
	    
        try{
            return ConverterType.Convert(str, Geometry.class);
        }catch(Exception e){
            return null;
        }
	}
 
	@Override
	public boolean isType(Object o) {
		// TODO Auto-generated method stub
		if(o instanceof Geometry){
			return true;
		}
		return false;
	}

	@Override
	public String getTypeName() {
		// TODO Auto-generated method stub
		return this.typeName;
	}

	@Override
	public SPATIAL_TYPE getSpatialType() {
		// TODO Auto-generated method stub
		return SPATIAL_TYPE.postgis;
	}
	@Override
	public Object toType(Object o) throws Exception {
		// TODO Auto-generated method stub
		if(this.isType(o)){
			return o;
		}else{
			return this.strToType(o.toString());
		}
	}
	 @Override
    public String valueToString(Object o) throws Exception {
        // TODO Auto-generated method stub
        if (o instanceof GeoBuffer) {
            GeoBuffer geoBuffer = (GeoBuffer)o;
            return geoBuffer.toGeometry().toText();
        }else if (o instanceof Geometry) {
            Geometry geometry = (Geometry)o;
            return geometry.toText();
        }else if(o instanceof byte[]){
            byte[] bytes = (byte[])o;
            return new String(bytes);
        }
        return null;
    }
}
