package com.northpool.resources.type;

import java.io.ByteArrayInputStream;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.io.WKBWriter;

import com.northpool.commons.type.ConverterType;
import com.northpool.resources.Constants.SPATIAL_TYPE;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.mgeom.MGeometryFactory;
import com.northpool.spatial.mysql.MySQLDecoder;

public class TypeMySQLGeometry implements Type, GeometryType {

	public static TypeMySQLGeometry INSTANCE = new TypeMySQLGeometry();

	protected String name = GeometryType.NAME;
	protected Class<?> clazz = GeoBuffer.class;
	protected String typeName = "MysqlGeometry";
	protected static MGeometryFactory defaultGeomFactory = new MGeometryFactory();
	
	
	@Override
	public SPATIAL_TYPE getSpatialType() {
		return SPATIAL_TYPE.mysql;
	}

	@Override
	public String name() {
		return this.name;
	}

	@Override
	public Class<?> getJavaClass() {
		return this.getClass();
	}

	@Override
	public Object getValueByResultSet(ResultSet rs, int index) throws Exception {
		// TODO Auto-generated method stub
		ByteArrayInputStream is = (ByteArrayInputStream) rs.getBinaryStream(index);
		if(is == null){
			return null;
		}
		return MySQLDecoder.decoder().toGeoBuffer(is);
	}

	@Override
	public void preparedStatementSetValue(PreparedStatement ps, Object o, int index) throws Exception {
		// TODO Auto-generated method stub
		if(o instanceof Geometry){
			Object byteObject = this.conv2DBGeometry((Geometry) o);
			ps.setObject(index, byteObject);
		}
	}

	@Override
	public Object strToType(String str) throws Exception {
	    if(str == null || "".equals(str)|| "null".equalsIgnoreCase(str)){
            return null;
        }
	    try{
	        return ConverterType.Convert(str, Geometry.class);
	    }catch(Exception e){
	        return null;
	    }
	}

	@Override
	public boolean isType(Object o) {
		if (o instanceof Geometry) {
			return true;
		}
		return false;
	}

	@Override
	public String getTypeName() {
		return this.typeName;
	}

	@Override
	public Object toType(Object o) throws Exception {
		if (this.isType(o)) {
			return o;
		} else {
			return this.strToType(o.toString());
		}
	}
	
	private Object conv2DBGeometry(Geometry jtsGeom) {
		if (jtsGeom.isEmpty()) {
			return null;
		}
		jtsGeom = forceGeometryCollection(jtsGeom);
		int srid = jtsGeom.getSRID();

		WKBWriter writer = new WKBWriter(2, 2);

		byte[] wkb = writer.write(jtsGeom);

		byte[] byteArr = new byte[wkb.length + 4];
		byteArr[3] = (byte) (srid >> 24 & 0xFF);
		byteArr[2] = (byte) (srid >> 16 & 0xFF);
		byteArr[1] = (byte) (srid >> 8 & 0xFF);
		byteArr[0] = (byte) (srid & 0xFF);
		System.arraycopy(wkb, 0, byteArr, 4, wkb.length);
		return byteArr;
	}
	
	private Geometry forceGeometryCollection(Geometry jtsGeom) {
		if (jtsGeom.isEmpty()) {
			return createEmptyGeometryCollection(jtsGeom);
		}
		if (jtsGeom instanceof GeometryCollection) {
			GeometryCollection gc = (GeometryCollection) jtsGeom;
			Geometry[] components = new Geometry[gc.getNumGeometries()];
			for (int i = 0; i < gc.getNumGeometries(); i++) {
				Geometry component = gc.getGeometryN(i);
				if (component.isEmpty()) {
					components[i] = jtsGeom.getFactory().createGeometryCollection(null);
				} else {
					components[i] = component;
				}
			}
			GeometryCollection geometryCollection1 = jtsGeom.getFactory().createGeometryCollection(components);
			geometryCollection1.setSRID(jtsGeom.getSRID());
			return geometryCollection1;
		}
		return jtsGeom;
	}

	private Geometry createEmptyGeometryCollection(Geometry jtsGeom) {
		MGeometryFactory mGeometryFactory = (MGeometryFactory) jtsGeom.getFactory();
		if (mGeometryFactory == null) {
			mGeometryFactory = defaultGeomFactory;
		}
		GeometryCollection geometryCollection = mGeometryFactory.createGeometryCollection(null);
		geometryCollection.setSRID(jtsGeom.getSRID());
		return geometryCollection;
	}

    /* (non-Javadoc)
     * @see com.northpool.resources.type.Type#valueToString(java.lang.Object)
     */
    @Override
    public String valueToString(Object o) throws Exception {
        // TODO Auto-generated method stub
        if (o instanceof GeoBuffer) {
            GeoBuffer geoBuffer = (GeoBuffer)o;
            return geoBuffer.toGeometry().toText();
        }else if (o instanceof Geometry) {
            Geometry geometry = (Geometry)o;
            return geometry.toText();
        }else{
            return null;
        }
    }
	
	

}
