package com.northpool.resources.type;

import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.locationtech.jts.geom.Geometry;

import com.northpool.commons.type.ConverterType;
import com.northpool.resources.Constants.SPATIAL_TYPE;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.oracle.GeometryOracleConverter;
import com.northpool.spatial.oracle.OracleConnectionFinder;
import com.northpool.spatial.oracle.OracleDecoder;

import oracle.jdbc.internal.OracleStruct;
import oracle.jdbc.driver.OracleConnection;



public class TypeOracleGeometry implements Type, GeometryType {

	public static TypeOracleGeometry INSTANCE = new TypeOracleGeometry();

	protected String name = GeometryType.NAME;
	protected Class<?> clazz = GeoBuffer.class;
	protected String typeName = "OracleGeometry";

	private GeometryOracleConverter gc;
	
	@Override
	public String name() {
		return name;
	}

	@Override
	public Class<?> getJavaClass() {
		return clazz;
	}

	

	@Override
	public Object getValueByResultSet(ResultSet rs, int index) throws Exception {
	/*	STRUCT is = (STRUCT) rs.getObject(index);
		if (is == null) {
			return null;
		}
		gc = new GeometryOracleConverter(null);
		System.out.println(gc.asGeometry(is).toString());*/
	//	return gc.asGeometry(is);
		
	    OracleStruct is = (OracleStruct) rs.getObject(index);	
		GeoBuffer geo;
		
		if(is == null){
		    return null;
		}
		
		geo = OracleDecoder.decoder().toGeoBuffer(is);
	
		
		return geo;
		
		
		
		
	}

	@Override
	public void preparedStatementSetValue(PreparedStatement ps, Object o, int index) throws Exception {
		if (o instanceof Geometry) {
			//ps.getMetaData().getCatalogName(index);
			OracleConnection con = OracleConnectionFinder.getInstance().find(ps.getConnection());
			GeometryOracleConverter gc = new GeometryOracleConverter(con);
			Object sdo = gc.toSDO((Geometry) o);
			ps.setObject(index, sdo);
			return;
		}
		if (o instanceof GeoBuffer) {
			//ps.getMetaData().getCatalogName(index);
			//以后需要改
			OracleConnection con = OracleConnectionFinder.getInstance().find(ps.getConnection());
			GeometryOracleConverter gc = new GeometryOracleConverter(con);
			GeoBuffer buffer = (GeoBuffer)o;
			Object sdo = gc.toSDO((Geometry) buffer.toGeometry());
			ps.setObject(index, sdo);
			return;
		}
		throw new Exception(String.format("TypeOracleGeometry方法preparedStatementSetValue不能适用于 %s",o.getClass().getName()));
	}

	@Override
	public Object strToType(String str) throws Exception {
	    if(str == null || "".equals(str)|| "null".equalsIgnoreCase(str)){
            return null;
        }
	    try{
	        return ConverterType.Convert(str, Geometry.class);
	    }catch(Exception e){
	        return null;
	    }
	}

	@Override
	public boolean isType(Object o) {
		if (o instanceof Geometry) {
			return true;
		}
		return false;
	}

	@Override
	public String getTypeName() {
		return this.typeName;
	}

	@Override
	public SPATIAL_TYPE getSpatialType() {
		return SPATIAL_TYPE.sdo;
	}

	@Override
	public Object toType(Object o) throws Exception {
		if (this.isType(o)) {
			return o;
		} else {
			return this.strToType(o.toString());
		}
	}
	
	 @Override
    public String valueToString(Object o) throws Exception {
        // TODO Auto-generated method stub
        if (o instanceof GeoBuffer) {
            GeoBuffer geoBuffer = (GeoBuffer)o;
            return geoBuffer.toGeometry().toText();
        }else if (o instanceof Geometry) {
            Geometry geometry = (Geometry)o;
            return geometry.toText();
        }else{
            return null;
        }
    }

}