package com.northpool.spatial.oracle;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;

import oracle.jdbc.driver.OracleConnection;

public class OracleConnectionFinder {
	
	private static OracleConnectionFinder OCF = new OracleConnectionFinder();
	
	public static OracleConnectionFinder getInstance(){
		return OCF;
	}
	
	protected Map<String,Method> methodMap = new HashMap<String,Method>();
	
	protected  Method createFindMethod(final Connection con){
		for (Method method : con.getClass().getMethods()) {
			if (method.getReturnType().isAssignableFrom(java.sql.Connection.class) && method.getParameterTypes().length == 0) {
				method.setAccessible(true);
				return method;
			}
		}
		return null;
	}


	public OracleConnection find(Connection con) throws FinderException {
		if (con == null) {
			return null;
		}
		if (con instanceof OracleConnection) {
			return (OracleConnection) con;
		}
		
		Method method = this.methodMap.get(con.getClass().getName());
		if(method == null){
			synchronized(this){
				if(method == null){
					method = this.createFindMethod(con);
					this.methodMap.put(con.getClass().getName(), method);
				}
			}
		}
		if(method != null){
			OracleConnection oc = null;
			try {
				oc = find((Connection) (method.invoke(con, new Object[] {})));
				if (oc == null) {
					throw new FinderException(String.format(
							"Tried retrieving OracleConnection from %s using method %s, but received null.",
							con.getClass().getCanonicalName(), method.getName()));
				}
			} catch (IllegalAccessException e) {
				throw new FinderException(String.format(
						"Illegal access on executing method %s when finding OracleConnection", method.getName()));
			}  catch (InvocationTargetException e) {
				throw new FinderException(
						String.format("Invocation exception on executing method %s when finding OracleConnection",
								method.getName()));
			}
			return oc;
		}
		
		throw new FinderException("Couldn't get at the OracleSpatial Connection object from the PreparedStatement.");
		
		
		
		
		
		
		
		
		
	}
}
