package com.northpool.spatial.postgresql;

import java.io.ByteArrayInputStream;

import org.locationtech.jts.io.ByteOrderValues;
import org.locationtech.jts.io.WKBConstants;

import com.northpool.spatial.ByteOrderDataInStream;
import com.northpool.spatial.Decoder;
import com.northpool.spatial.GeometryInfo;
import com.northpool.spatial.Constants.GEO_TYPE;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.wkb.WkbDecoder;

public class EwkbDecoder extends WkbDecoder implements Decoder<ByteArrayInputStream> {

	/* (non-Javadoc)
	 * @see com.northpool.spatial.Decoder#toGeoBuffer(java.lang.Object)
	 */
	
	
	protected static EwkbDecoder _decoder = new EwkbDecoder();
	
	public static EwkbDecoder decoder(){
		return _decoder;
	}
	
	
	
	
	
	@Override
	public GeoBuffer toGeoBuffer(ByteArrayInputStream instream) throws Exception {
		
		if (null == instream || instream.available() <= 0){
			System.out.println("instream is null");
			throw new Exception("流不能为空");
		}
		
		ByteOrderDataInStream dis = new ByteOrderDataInStream(instream,true);
		
	    byte byteOrderWKB = dis.readByte();
	    // always set byte order, since it may change from geometry to geometry
		int byteOrder = byteOrderWKB == WKBConstants.wkbNDR ? ByteOrderValues.LITTLE_ENDIAN : ByteOrderValues.BIG_ENDIAN;
		dis.setOrder(byteOrder);
		
		int typeInt = dis.readInt();
		GeometryInfo info = new GeometryInfo();
		info.setGeometryType( typeInt  & 0x1FFFFFFF);
	    // determine if Z values are present
		info.setHasZ((typeInt & 0x80000000) != 0);
		info.setHasM((typeInt & 0x40000000) != 0);
		boolean haveSrid = (typeInt & 0x20000000) != 0;
		int srid = 0;
		if (haveSrid) {
			srid = dis.readInt();
		}
		
		
		int size = instream.available();
		
		GEO_TYPE geoType = is(info.getGeometryType());
		
		int inputDimension =  info.isHasZ() ? 3 : 2;

		GeoBuffer geo = new GeoBuffer(geoType,srid,inputDimension);
		
		return this.process(geoType, dis, geo, info);
	}
	
	
	
	
	
}
