/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.db;

import com.northpool.commons.reflect.Bean;
import com.northpool.resources.command.Constants;
import com.northpool.resources.command.QueryFilter;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.IField;
import com.northpool.resources.datatable.ITable;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IDAO;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.datatable.db.operate.IDBTableOperator;
import com.northpool.resources.sql.IBatchDataScroll;
import com.northpool.resources.sql.SQLParameter;
import com.northpool.resources.sql.SQLQueryEngine;
import com.northpool.resources.sql.jdbc.IJDBCTransformer;
import com.northpool.resources.sql.jdbc.JDBCGenericDaoImpl;
import com.northpool.type.Type;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AbstractDBDAO<PK, T>
extends JDBCGenericDaoImpl
implements IDAO<T, PK> {
    protected ITable table;
    protected Class<?> clazz;
    protected IJDBCTransformer<T> transformer;

    public AbstractDBDAO(IDataSource dataSource, ITable table, IJDBCTransformer<T> transformer) {
        super(dataSource);
        this.table = table;
        this.transformer = transformer;
    }

    protected void checkWriteable() {
        if (this.table.getIsView().booleanValue()) {
            throw new RuntimeException(this.table.mark() + "\u4e3a\u8bd5\u56fe,\u4e0d\u80fd\u6267\u884c\u5199\u64cd\u4f5c");
        }
    }

    public T get(PK pk) throws DataAccessException {
        String idFiled = this.table.getIdField();
        QueryFilter filter = new QueryFilter();
        filter.addFilter(idFiled, Constants.OPERATION.EQ, new Object[]{pk});
        List<T> ii = this.query(filter);
        if (ii.isEmpty()) {
            return null;
        }
        return ii.get(0);
    }

    public List<T> query(QueryFilter filter) throws DataAccessException {
        return this.query(filter, null);
    }

    public IScroll<T> scroll(QueryFilter filter, Integer fetchSize) throws DataAccessException {
        return this._scroll(filter, fetchSize, this.transformer);
    }

    private <ST> IScroll<ST> _scroll(QueryFilter filter, Integer fetchSize, IJDBCTransformer<ST> transformer) throws DataAccessException {
        SQLQueryEngine engine = null;
        try {
            engine = new SQLQueryEngine(this.table, filter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        IScroll<ST> s = this.scrollBySql(parameter.getSql(), parameter.getValues(), parameter.getTypes(), parameter.getReturnTypeMap(), filter.getStart(), filter.getEnd(), fetchSize, transformer);
        return s;
    }

    public Long count(QueryFilter filter) throws DataAccessException {
        SQLQueryEngine engine = null;
        try {
            engine = new SQLQueryEngine(this.table, filter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        Long count = this.getCountBySql(parameter.getSql(), parameter.getValues(), parameter.getTypes());
        return count;
    }

    public void insert(T t) throws DataAccessException {
        this.insert(t, false);
    }

    public void insert(T t, Boolean insertNull) throws DataAccessException {
        int size = this.table.fields().length;
        String[] fieldsInDB = new String[size];
        String[] fields = new String[size];
        Type[] types = new Type[size];
        for (int index = 0; index < size; ++index) {
            IField field = this.table.fields()[index];
            fieldsInDB[index] = field.getOriginFieldName();
            fields[index] = field.getFieldName();
            types[index] = field.getType();
        }
        Object[] args = null;
        if (insertNull.booleanValue()) {
            args = new Object[size];
            for (int i = 0; i < fieldsInDB.length; ++i) {
                String fieldName = fields[i];
                args[i] = Bean.getObjectValueByFieldName(t, (String)fieldName);
            }
        } else {
            ArrayList<String> newFieldInDb = new ArrayList<String>(size);
            ArrayList<Object> argsList = new ArrayList<Object>(size);
            ArrayList<Type> typeList = new ArrayList<Type>(size);
            for (int i = 0; i < fieldsInDB.length; ++i) {
                String fieldInDB = fieldsInDB[i];
                String fieldName = fields[i];
                Object o = Bean.getObjectValueByFieldName(t, (String)fieldName);
                if (o == null) continue;
                newFieldInDb.add(fieldInDB);
                argsList.add(o);
                typeList.add(((IField)this.table.getFieldsInTableMap().get(fieldInDB)).getType());
            }
            fieldsInDB = newFieldInDb.toArray(new String[newFieldInDb.size()]);
            args = argsList.toArray(new Object[argsList.size()]);
            types = typeList.toArray(new Type[typeList.size()]);
        }
        String sql = this.dialect.createInsertSQL(((IDBTableOperator)this.table.getTableOperator()).getSchema(), this.table.getTablename(), fieldsInDB);
        this.doExecuteSql(sql, args, types);
    }

    public void remove(PK pk) throws DataAccessException {
        String idFieldName = this.table.getIdField();
        IField idField = (IField)this.table.getFieldsMap().get(idFieldName);
        String idFieldNameInDB = idField.getOriginFieldName();
        String sql = this.dialect.createDeleteSQL(((IDBTableOperator)this.table.getTableOperator()).getSchema(), this.table.getTablename(), idFieldNameInDB + " = ?");
        this.doExecuteSql(sql, new Object[]{pk}, new Type[]{idField.getType()});
    }

    public void update(T t) throws DataAccessException {
        String idFieldName = this.table.getIdField();
        String idFieldNameInDB = ((IField)this.table.getFieldsMap().get(idFieldName)).getOriginFieldName();
        int size = this.table.fields().length;
        String[] fieldsInDB = new String[size];
        String[] fields = new String[size - 1];
        Type[] types = new Type[size];
        Object[] args = new Object[size];
        int i = 0;
        for (int index = 0; index < this.table.fieldSize(); ++index) {
            IField field = this.table.fields()[index];
            if (field.isPK().booleanValue()) continue;
            fieldsInDB[i] = field.getOriginFieldName();
            fields[i] = field.getFieldName();
            types[i] = field.getType();
            args[i] = Bean.getObjectValueByFieldName(t, (String)field.getFieldName());
            ++i;
        }
        types[size - 1] = this.table.getTableOperator().getPKColumnInfo().getType();
        args[size - 1] = Bean.getObjectValueByFieldName(t, (String)idFieldName);
        String sql = this.dialect.createUpdateSQL(((IDBTableOperator)this.table.getTableOperator()).getSchema(), this.table.getTablename(), fields, idFieldNameInDB + " = ?");
        this.doExecuteSql(sql, args, types);
    }

    public void saveOrUpdate(T t) throws DataAccessException {
        T inDB;
        Object pk = Bean.getObjectValueByFieldName(t, (String)this.table.getIdField());
        if (pk == null) {
            this.insert(t);
        }
        if ((inDB = this.get(pk)) == null) {
            this.insert(t);
        } else {
            this.update(t);
        }
    }

    public List<T> query(QueryFilter filter, Integer fetchSize) {
        return this._query(filter, fetchSize, this.transformer);
    }

    public IScroll<Object> scrollId(QueryFilter filter, Integer fetchSize) throws DataAccessException {
        filter.setOutputFieldNames(this.table.getIdField());
        SQLQueryEngine engine = null;
        try {
            engine = new SQLQueryEngine(this.table, filter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        return this.scrollBySql(parameter.getSql(), parameter.getValues(), parameter.getTypes(), parameter.getReturnTypeMap(), filter.getStart(), filter.getEnd(), fetchSize, IJDBCTransformer.ONEFILED);
    }

    public void update(PK pk, T t) throws DataAccessException {
        String idFieldName = this.table.getIdField();
        String idFieldNameInDB = ((IField)this.table.getFieldsMap().get(idFieldName)).getOriginFieldName();
        int size = this.table.fields().length;
        String[] fieldsInDB = new String[size];
        String[] fields = new String[size - 1];
        Type[] types = new Type[size];
        Object[] args = new Object[size];
        int i = 0;
        for (int index = 0; index < this.table.fieldSize(); ++index) {
            IField field = this.table.fields()[index];
            if (field.isPK().booleanValue()) continue;
            fieldsInDB[i] = field.getOriginFieldName();
            fields[i] = field.getFieldName();
            types[i] = field.getType();
            args[i] = Bean.getObjectValueByFieldName(t, (String)field.getFieldName());
            ++i;
        }
        types[size - 1] = this.table.getTableOperator().getPKColumnInfo().getType();
        args[size - 1] = pk;
        String sql = this.dialect.createUpdateSQL(((IDBTableOperator)this.table.getTableOperator()).getSchema(), this.table.getTablename(), fields, idFieldNameInDB + " = ?");
        this.doExecuteSql(sql, args, types);
    }

    public void insertMany(List<T> list, Integer batchSize) throws DataAccessException {
        this.insertMany(list, true, batchSize);
    }

    public void insertMany(final List<T> list, Boolean insertPK, Integer batchSize) throws DataAccessException {
        int size = this.table.fields().length;
        ArrayList<String> fieldsInDBArr = new ArrayList<String>();
        ArrayList<String> fieldsArr = new ArrayList<String>();
        ArrayList<Type> typesArr = new ArrayList<Type>();
        for (int index = 0; index < size; ++index) {
            IField field = this.table.fields()[index];
            if (field.isPK().booleanValue() && !insertPK.booleanValue()) continue;
            fieldsInDBArr.add(field.getOriginFieldName());
            fieldsArr.add(field.getFieldName());
            typesArr.add(field.getType());
        }
        String[] fieldsInDB = fieldsInDBArr.toArray(new String[fieldsInDBArr.size()]);
        final String[] fields = fieldsArr.toArray(new String[fieldsArr.size()]);
        Type[] types = typesArr.toArray(new Type[typesArr.size()]);
        String sql = this.dialect.createInsertSQL(((IDBTableOperator)this.table.getTableOperator()).getSchema(), this.table.getTablename(), fieldsInDB);
        IBatchDataScroll scroll = new IBatchDataScroll(){
            Iterator<T> iterator;
            {
                this.iterator = list.iterator();
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public Object[] next() {
                Object data = this.iterator.next();
                Object[] values = new Object[fields.length];
                for (int i = 0; i < fields.length; ++i) {
                    Object value;
                    String field = fields[i];
                    values[i] = value = Bean.getObjectValueByFieldName(data, (String)field);
                }
                return values;
            }

            public int size() {
                return list.size();
            }
        };
        this.doBatchExecuteSql(sql, types, scroll, batchSize);
    }

    public void insertMany(List<Object[]> list, String[] fields, Integer batchSize) throws DataAccessException {
        String[] fieldsInDB = new String[fields.length];
        Type[] types = new Type[fields.length];
        Map mapField = this.table.getFieldsMap();
        for (int i = 0; i < fields.length; ++i) {
            String field = fields[i];
            IField dbField = (IField)mapField.get(field);
            if (dbField == null) {
                throw new RuntimeException(String.format("\u8868:%s\u4e2d\u6ca1\u6709\u627e\u5230\u5b57\u6bb5 %s", this.table.mark(), field));
            }
            fieldsInDB[i] = dbField.getOriginFieldName();
            types[i] = dbField.getType();
        }
        String sql = this.dialect.createInsertSQL(((IDBTableOperator)this.table.getTableOperator()).getSchema(), this.table.getTablename(), fieldsInDB);
        this.doBatchExecuteSql(sql, list, types, batchSize);
    }

    public IScroll<T> scroll(QueryFilter filter) throws DataAccessException {
        return this.scroll(filter, null);
    }

    public void removeAll() throws DataAccessException {
    }

    public void insertMany(List<T> list) throws DataAccessException {
        this.insertMany(list, null);
    }

    public void updateMany(T t, QueryFilter queryFilter) throws DataAccessException {
    }

    public void remove(QueryFilter queryFilter) throws DataAccessException {
    }

    private <QT> List<QT> _query(QueryFilter filter, Integer fetchSize, IJDBCTransformer<QT> transformer) throws DataAccessException {
        SQLQueryEngine engine = null;
        try {
            engine = new SQLQueryEngine(this.table, filter);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        SQLParameter parameter = engine.toNativeSQL();
        List<QT> i = this.queryBySql(parameter.getSql(), parameter.getValues(), parameter.getTypes(), parameter.getReturnTypeMap(), filter.getStart(), filter.getEnd(), fetchSize, transformer);
        return i;
    }

    public List<Object[]> queryArray(QueryFilter filter, Integer fetchSize) throws DataAccessException {
        return this._query(filter, fetchSize, IJDBCTransformer.ARRAY);
    }

    public IScroll<Object[]> scrollArray(QueryFilter queryFilter, Integer fetchSize) throws DataAccessException {
        return this._scroll(queryFilter, fetchSize, IJDBCTransformer.ARRAY);
    }
}

