/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datatable.db.operate;

import com.northpool.resources.Constants;
import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datatable.db.operate.AbstractDBTableOperator;
import com.northpool.resources.datatable.db.operate.IDBTableOperator;
import com.northpool.resources.datatable.db.operate.column.OracleColumn;
import com.northpool.resources.datatable.operate.ATableOperator;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.datatable.operate.IIndex;
import com.northpool.resources.datatable.operate.Index;
import com.northpool.resources.sql.jdbc.IJDBCTransformer;
import com.northpool.spatial.Constants;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@ATableOperator(name="oracle", type=Constants.DATA_SOURCE_TYPE.oracle)
public class OracleTableOperator
extends AbstractDBTableOperator
implements IDBTableOperator {
    @Override
    protected void processTableNameAndSchema(String tableName, String schema, Boolean isCaseSensitive) {
        if (tableName.contains(".")) {
            String[] arr = tableName.split("\\.");
            tableName = arr[0];
            schema = arr[1];
        }
        DbDataSource dbDataSource = (DbDataSource)this.dataSource;
        if (schema == null) {
            schema = dbDataSource.getUser();
        }
        this.tableName = tableName.toUpperCase();
        this.schema = schema.toUpperCase();
        if (isCaseSensitive.booleanValue()) {
            tableName = tableName.toLowerCase();
            schema = schema.toLowerCase();
        }
    }

    @Override
    protected String getRemarks(ResultSet columns) throws SQLException {
        return columns.getString("REMARKS");
    }

    @Override
    protected ResultSet getColumns(DatabaseMetaData dbmd, String tableName, String schema) throws SQLException {
        ResultSet columns = dbmd.getColumns(null, this.schema, this.tableName.replace("\"", ""), null);
        return columns;
    }

    @Override
    protected IColumn createColumn(String columnName, Integer columnSize, Integer digits, String columnTypeName, Boolean nullable, String defaultValue, String colRemarks) {
        OracleColumn column = new OracleColumn(columnName, (int)columnSize, (int)digits, columnTypeName, (boolean)nullable, defaultValue, colRemarks, this.dialect);
        return column;
    }

    @Override
    public CompletableFuture<Object> dropIndex(String indexName) {
        IIndex index = (IIndex)this.indexMap.get(indexName);
        if (index == null) {
            try {
                DatabaseMetaData dbmd = this.dbconn.getMetaData();
                index = this.getIndexInfo(dbmd).get(indexName);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        if (index == null) {
            return null;
        }
        if (index.getSpatial().booleanValue()) {
            String sql = "delete from SDO_GEOM_METADATA_TABLE where SDO_TABLE_NAME = ? and SDO_COLUMN_NAME = ?";
            this.genericDao.doExecuteSql(sql, new Object[]{this.tableName, index.getColname()}, null);
        }
        return super.dropIndex(indexName);
    }

    @Override
    protected CompletableFuture<Object> createSpatialIndex(String colname) {
        Integer srid = this.getSRID(colname);
        Constants.SPATIAL_UNIT unit = Constants.getSpatialUnitBySRID((Integer)srid);
        StringBuffer inster = new StringBuffer();
        inster.append("INSERT INTO SDO_GEOM_METADATA_TABLE");
        inster.append("(SDO_OWNER,SDO_TABLE_NAME,SDO_COLUMN_NAME,SDO_DIMINFO,SDO_SRID)");
        inster.append(" VALUES  (");
        inster.append(this.schema);
        inster.append(this.tableName);
        inster.append(colname);
        if (unit == Constants.SPATIAL_UNIT.degree) {
            inster.append("MDSYS.SDO_DIM_ARRAY (").append("MDSYS.SDO_DIM_ELEMENT('X', -180.0, 180.0, 0.005),").append("MDSYS.SDO_DIM_ELEMENT('Y', -90.0,90.0, 0.005))");
        } else {
            inster.append("MDSYS.SDO_DIM_ARRAY (").append("MDSYS.SDO_DIM_ELEMENT('X', -20037508, 20037508, 0.5),").append("MDSYS.SDO_DIM_ELEMENT('Y', -20037508,20037508, 0.5))");
        }
        inster.append(srid);
        inster.append(")");
        this.genericDao.doExecuteSql(inster.toString(), null, null);
        CompletableFuture<Object> promise = CompletableFuture.supplyAsync(() -> {
            this.logger.info(this.mark() + "_" + colname + "\u521b\u5efa\u7a7a\u95f4\u7d22\u5f15");
            String indexName = this.createSpatialIndexName(colname);
            String sql = "CREATE INDEX " + indexName + " ON " + this.tableName + "(" + colname + ") INDEXTYPE IS MDSYS.SPATIAL_INDEX;";
            this.logger.info("execute sql" + sql);
            this.genericDao.doExecuteSql(sql, null, null);
            Index index = new Index();
            index.setName(indexName);
            index.setUnique(Boolean.valueOf(false));
            index.isSpatial(Boolean.valueOf(true));
            index.setColname(colname);
            this.addToIndexMap(colname, (IIndex)index);
            return null;
        });
        return promise;
    }

    protected Object[] getSpatialInfo(String colunmName) throws SQLException {
        String sql = "SELECT SRID FROM USER_SDO_GEOM_METADATA WHERE TABLE_NAME = ?";
        List<Map<String, Object>> i = this.genericDao.queryBySql(sql, new Object[]{colunmName}, null, null, null, null, null, IJDBCTransformer.MAP);
        if (i.isEmpty()) {
            return null;
        }
        Map<String, Object> data = i.get(0);
        Integer srid = (Integer)data.get("SRID");
        return new Object[]{srid, Constants.GEO_TYPE.GEOMETRY};
    }

    @Override
    protected String getCataLog() throws SQLException {
        return null;
    }

    @Override
    protected void getTableInfo(DatabaseMetaData dbmd, String tableName) throws SQLException {
        try (ResultSet resultSet = dbmd.getTables(null, this.schema, this.tableName, new String[]{"TABLE", "VIEW"});){
            boolean isNull = true;
            while (resultSet.next()) {
                isNull = false;
                String type = resultSet.getString("TABLE_TYPE");
                this.tableRemarks = resultSet.getString("REMARKS");
                if ("TABLE".equalsIgnoreCase(type)) continue;
                this.isView = true;
            }
            if (isNull) {
                throw new RuntimeException("\u8868/\u89c6\u56fe" + this.schema + "." + tableName + "\u4e0d\u5b58\u5728");
            }
            resultSet.close();
        }
    }
}

