/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.spatial.oracle;

import com.northpool.spatial.oracle.FinderException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Map;
import oracle.jdbc.driver.OracleConnection;

public class OracleConnectionFinder {
    private static OracleConnectionFinder OCF = new OracleConnectionFinder();
    protected Map<String, Method> methodMap = new HashMap<String, Method>();

    public static OracleConnectionFinder getInstance() {
        return OCF;
    }

    protected Method createFindMethod(Connection con) {
        for (Method method : con.getClass().getMethods()) {
            if (!method.getReturnType().isAssignableFrom(Connection.class) || method.getParameterTypes().length != 0) continue;
            method.setAccessible(true);
            return method;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OracleConnection find(Connection con) throws FinderException {
        if (con == null) {
            return null;
        }
        if (con instanceof OracleConnection) {
            return (OracleConnection)con;
        }
        Method method = this.methodMap.get(con.getClass().getName());
        if (method == null) {
            OracleConnectionFinder oracleConnectionFinder = this;
            synchronized (oracleConnectionFinder) {
                if (method == null) {
                    method = this.createFindMethod(con);
                    this.methodMap.put(con.getClass().getName(), method);
                }
            }
        }
        if (method != null) {
            OracleConnection oc = null;
            try {
                oc = this.find((Connection)method.invoke((Object)con, new Object[0]));
                if (oc == null) {
                    throw new FinderException(String.format("Tried retrieving OracleConnection from %s using method %s, but received null.", con.getClass().getCanonicalName(), method.getName()));
                }
            }
            catch (IllegalAccessException e) {
                throw new FinderException(String.format("Illegal access on executing method %s when finding OracleConnection", method.getName()));
            }
            catch (InvocationTargetException e) {
                throw new FinderException(String.format("Invocation exception on executing method %s when finding OracleConnection", method.getName()));
            }
            return oc;
        }
        throw new FinderException("Couldn't get at the OracleSpatial Connection object from the PreparedStatement.");
    }
}

