/**
　 * <p>Title: AbstractDBDataSourceOperater.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年11月26日
　 * @version 1.0
*/
package com.northpool.resources.datasource.db.operate;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Map.Entry;
import java.util.Optional;

import com.northpool.commons.filechannel.SplitFilePart;
import com.northpool.resources.datasource.IDataSourceOperator;
import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.datatable.operate.FieldDefaultValueBean;
import com.northpool.resources.datatable.operate.IndexBean;
import com.northpool.resources.datatable.operate.TableSchemaBean;
import com.northpool.resources.datatable.operate.FieldDefaultValueBean.VALUE_TYPE;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;


/**
 * @author matt
 *
 */
public abstract class AbstractDBDataSourceOperator implements IDataSourceOperator<DbDataSource> {
    
    public abstract String getSchemaWhenGetTables(DbDataSource pool);
    
    public abstract String getTableName(String schema,String tableName);
    
    
    @Override
    public String[] tables(DbDataSource pool) {
       
        String schema = this.getSchemaWhenGetTables(pool);

        javax.sql.DataSource datasource = pool.connection();
        Connection connection = null;
        DatabaseMetaData databaseMetaData;
        ResultSet ts = null;
        try {
            List<String> list = new ArrayList<>();
            connection = datasource.getConnection();
            databaseMetaData = connection.getMetaData();
            ts = databaseMetaData.getTables(null, schema, null,new String[]{"TABLE"});
            while (ts.next()) {
                String tableName = ts.getString("TABLE_NAME");
                list.add(tableName);
            }
            return list.toArray(new String[list.size()]);
        } catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            try {
                ts.close();
                
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            try {
                connection.close();
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }

   
    @Override
    public void drop(DbDataSource pool,String tableName) {
        // TODO Auto-generated method stub
        ISQLDialect dialect = (ISQLDialect)IDialect.getByType(pool.getDataSourceType());
        if(dialect.markForTableNameAndColumnName()){
            tableName = "\"" + tableName + "\"";
        }
        String sql = "drop table " + tableName;
        pool.genericDao().doExecuteSql(sql, null, null);
    }

   
    
    
    @Override
    public void createTableBySchemaBean(DbDataSource pool,TableSchemaBean tableSchemaBean) {
        // TODO Auto-generated method stub
        ISQLDialect dialect = (ISQLDialect)IDialect.getByType(pool.getDataSourceType());
        //如果有序列,先创建序列;
       // tableSchemaBean.getUseSequence()
        tableSchemaBean.getColumnMap().forEach( (fieldName,columnBean) ->{
            FieldDefaultValueBean fieldDefaultValue = columnBean.getFieldDefaultValue();
            if(fieldDefaultValue != null){
                if(fieldDefaultValue.getType() == VALUE_TYPE.sequence){
                    String sequenceNameRoot = dialect.createSequenceName(tableSchemaBean.getSchema(),tableSchemaBean.getTableName(),fieldName);
                    int i = 0;
                    String sequenceName = sequenceNameRoot;
                    while(hasSequence(pool,sequenceNameRoot)){
                        sequenceName = sequenceNameRoot + "_" + i;
                        i ++;
                    }
                    this.createSequence(pool,sequenceName);
                    fieldDefaultValue.setSequenceName(sequenceName);
                }
            }
        });
        
        //创建表SQL
        String[] sqlArray = dialect.getCreateTableSQLS(tableSchemaBean);
        for(String sql : sqlArray){
            pool.genericDao().doExecuteSql(sql);
        }
        Optional<Entry<String,ColumnBean>> optional = tableSchemaBean.getColumnMap().entrySet().stream().filter( entry ->{
            return entry.getValue().getIsPK();
        }).findFirst();
        
        String pkColumnName = null;
        
        if (optional.isPresent()) {
            pkColumnName = optional.get().getValue().getColumnName();
        } 
        
        if(pkColumnName != null){
            try {
                pool.getTableOperator(tableSchemaBean.getTableName()).createPK(pkColumnName);
            } catch (Exception e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
                throw new DataAccessException(e);
            }
        }
        //创建主键

        
    }
    
    /**
     * 是否有序列
     * @param sequenceName
     * @return
     */
    Boolean hasSequence(DbDataSource pool,String sequenceName){
        ISQLDialect dialect = (ISQLDialect)IDialect.getByType(pool.getDataSourceType());
        String sql = dialect.hasSequenceSql(sequenceName);
        List<Map<String,Object>> i = pool.genericDao().queryBySql(sql,new Object[]{sequenceName});
        if(i.isEmpty()){
            return false;
        }else{
            return true;
        }
        
    }
    
    void createSequence(DbDataSource pool,String sequenceName){
        ISQLDialect dialect = (ISQLDialect)IDialect.getByType(pool.getDataSourceType());
        String sql = dialect.getCreateSequenceSQL(sequenceName);
        pool.genericDao().doExecuteSql(sql);
    }
    
    
    public void createTableIndexBySchemaBean(DbDataSource pool,TableSchemaBean tableSchemaBean){
        Map<String, IndexBean> indexMap = tableSchemaBean.getIndexMap();
        
        
        
        
    }
    
    
    

    
    public List<String> schemas(DbDataSource pool){
        javax.sql.DataSource dataSource = pool.connection();
        Connection connection = null;
        DatabaseMetaData databaseMetaData;
        ResultSet set = null;
        try {
            connection = dataSource.getConnection();
            databaseMetaData = connection.getMetaData();
            set = databaseMetaData.getSchemas();
            ArrayList<String> schemas = new ArrayList<String>();
            while (set.next()) {
                schemas.add(set.getString("TABLE_SCHEM"));
            }
            return schemas; 
        } catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            try {
                set.close();
                
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            try {
                connection.close();
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            
        }

    }
    
    
   
    @Override
    public Boolean hasSchema(DbDataSource pool,String schema) {
        return true;
    }
    
   

  
    @Override
    public Boolean hasTable(DbDataSource pool,String tableName) {
        // TODO Auto-generated method stub
        // TODO Auto-generated method stub
        String[] arr = tableName.split("\\.");
        String schema = null;
        
        if(arr.length > 1){
            schema = arr[0];
            tableName = arr[1];
        }else{
            ISQLDialect dialect = (ISQLDialect)IDialect.getByType(pool.getDataSourceType());
            schema = dialect.getDefaultSchema();
        }

        
        javax.sql.DataSource dataSource = pool.connection();
        Connection connection = null;
        DatabaseMetaData databaseMetaData;
        ResultSet set = null;
        try {
            connection = dataSource.getConnection();
            databaseMetaData = connection.getMetaData();
            set = databaseMetaData.getTables(null, schema, tableName, new String[] { "TABLE" });
            return set.first(); 
        } catch (SQLException e) {
            throw new DataAccessException(e);
        } finally {
            try {
                set.close();
                
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
            try {
                connection.close();
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
            }
        }
    }
}
