package com.northpool.resources.datatable.db.operate.column;


import com.northpool.commons.util.Functions;
import com.northpool.resources.datatable.db.operate.PostgresTableOperator;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.spatial.Constants.SPATIAL_TYPE;
import com.northpool.type.TypeBigDecimal;
import com.northpool.type.TypeInteger;

public class PostgresColumn extends AbstractDBColumn implements IColumn {

	protected PostgresTableOperator postgresTableOperator;
	
	
	
	public PostgresColumn(String columnName, int columnSize, int digits,
			String columnTypeName, boolean nullable, String defaultValue, String remarks,ISQLDialect sqlDialect) {
		super(columnName, columnSize, digits, columnTypeName, nullable, defaultValue, remarks,sqlDialect);
		// TODO Auto-generated constructor stub
	}



	@Override
	protected void initAttType() {
		
		if (Functions.hasMask(this.columnTypeName, "NUMBER") || Functions.hasMask(this.columnTypeName, "NUMERIC")){
			if (this.columnSize <= 10) {
				this.type = TypeInteger.INSTANCE;
			}else{
				this.type = TypeBigDecimal.INSTANCE;
			}
		}else{
			this.type = this.dialect.getTypeByName(this.columnTypeName);
		}
		
		
		if(Functions.hasMask(this.columnTypeName, "GEOMETRY")){
			this.isSpatial = true;
		}
	}



    
    @Override
    public SPATIAL_TYPE getSpatialType() {
        // TODO Auto-generated method stub
        return SPATIAL_TYPE.hexwkb;
    }



  
    


	
	
	


}
