package com.northpool.resources.dialect.db.postgresql;


import com.northpool.commons.util.StringUtility;
import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.dialect.ADialect;
import com.northpool.resources.dialect.ICreateTableFieldRefDialect;
import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.dialect.function.sql.SQLSpatialRelateFunction;
import com.northpool.resources.dialect.function.sql.SpatialFilterExpression;
import com.northpool.resources.dialect.function.sql.StandardSQLFunction;
import com.northpool.resources.dialect.sql.AbstractSQLDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;

import com.northpool.spatial.Geom;
import com.northpool.type.TypePostGisGeometry;
import com.northpool.type.TypeString;
import com.northpool.type.Types;
import com.northpool.type.Type;
import com.northpool.type.TypeBytes;


import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.List;

@ADialect(name = "postgreSQL",type = DATA_SOURCE_TYPE.postgreSQL)
public class PostgreSQLDialect extends AbstractSQLDialect implements ISQLDialect {

	public static PostgreSQLDialect INSTANCE = new PostgreSQLDialect();
	
	//public static PostgresFieldRefDialect FIELD_REF_DIALECT = new PostgresFieldRefDialect();
	
	//自增关键字
	 
	public static final String KEY_WORD_SERIAL = "serial";
	
	public static final String KEY_WORD_NOW_DATE = "current_timestamp";
	
	public static final String KEY_WORD_CURRENT_TIMESTAMP = "current_timestamp";
	
	public static final String KET_WORD_DEFAULT_SCHEMA = "public";
	
	public static final PostgresSQLResourcesDataInput resourcesDataInput = new PostgresSQLResourcesDataInput();
	
	public static final PostgresSQLResourcesDataOutput resourcesDataOutput = new PostgresSQLResourcesDataOutput();
	
	public PostgreSQLDialect(){

		super();
		this.name = DATA_SOURCE_TYPE.postgreSQL.name();
		
	}
	
	@Override
	public DATA_SOURCE_TYPE getDataSourceType() {
		return DATA_SOURCE_TYPE.postgreSQL;
	}
	
	/**
     * 处理schema和tableName
     * @param schema
     * @param tableName
     * @return
     */
    public String processTableNameAndSchema(String schema,String tableName){
        if(schema != null && !"".equalsIgnoreCase(schema)){
            return schema + "." + tableName;
        }else{
            return tableName;
        }
    }
	
	@Override
	protected void registerTypes(){
		this.registerType(Types.INTEGER, "serial","int", "int2", "int4", "integer", "smallint");
		this.registerClassType(Types.INTEGER, Integer.class,Short.class);
		this.registerType(TypePostGisGeometry.INSTANCE, "geometry");
		this.registerClassType(TypePostGisGeometry.INSTANCE, Geom.class);
		this.registerType(Types.STRING, "varchar","bpchar","character varying","text","json","jsonb","path","name");
		this.registerClassType(Types.STRING, String.class);
		this.registerType(Types.DOUBLE, "float","float4","float8","double", "double precision");
		this.registerClassType(Types.DOUBLE, Double.class,Float.class);
		this.registerType(Types.BIGDECIMAL, "numeric","number");
		this.registerClassType(Types.BIGDECIMAL, BigDecimal.class,BigInteger.class);
		this.registerType(Types.TIME_STAMP, "timestamp","date");
		this.registerClassType(Types.TIME_STAMP, Date.class);
		this.registerType(Types.BOOLEAN, "boolean", "bool");
		this.registerClassType(Types.BOOLEAN, Boolean.class);	
		this.registerType(Types.LONG, "long","int8");
		this.registerClassType(Types.LONG, Long.class); 
		this.registerType(TypeBytes.INSTANCE, "bytea","byte[]");
        this.registerClassType(TypeBytes.INSTANCE, byte[].class); 
	}
	

	@Override
	public String getSelfDesc() {
		// TODO Auto-generated method stub
		return "PostgreSQL方言";
	}

	
	@Override
	protected void registerFunctions() {
		Type[] typeIn = new Type[]{ TypePostGisGeometry.INSTANCE, TypePostGisGeometry.INSTANCE};
		//注册空间关系函数
		this.registerFunction("intersects", new SQLSpatialRelateFunction("st_intersects", Types.BOOLEAN,typeIn));
		this.registerFunction("equals", new SQLSpatialRelateFunction("st_equals", Types.BOOLEAN,typeIn));
		this.registerFunction("contains", new SQLSpatialRelateFunction("st_contains", Types.BOOLEAN,typeIn));
		this.registerFunction("crosses", new SQLSpatialRelateFunction("st_crosses", Types.BOOLEAN,typeIn));
		this.registerFunction("disjoint", new SQLSpatialRelateFunction("st_disjoint", Types.BOOLEAN,typeIn));
		this.registerFunction("touches", new SQLSpatialRelateFunction("st_touches", Types.BOOLEAN,typeIn));
		this.registerFunction("within", new SQLSpatialRelateFunction("st_within", Types.BOOLEAN,typeIn));
		this.registerFunction("overlaps", new SQLSpatialRelateFunction("st_overlaps", Types.BOOLEAN,typeIn));
		this.registerFunction("mbr_intersects", new SpatialFilterExpression(Types.BOOLEAN,typeIn));
	//	this.registerFunction("relate", new SpatialRelateFunction("st_relate", Types.BOOLEAN,typeIn));
		
		this.registerFunction("encode", new StandardSQLFunction("encode",
                new Type[] {TypeBytes.INSTANCE, TypeString.INSTANCE}, Types.STRING));
	}

	
	
	


	@Override
	public String getJDBCDriver() {
		return "org.postgresql.Driver";
	}

	@Override
	public String createConnectUrl(String url) {
		return "jdbc:postgresql://" + url;
	}

	@Override
	public Boolean markForTableNameAndColumnName() {
		// TODO Auto-generated method stub
		return true;
	}

	
	
	
	

	
/*	protected void registerTypesAndFunctions() {
		// registerColumnType(java.sql.Types.STRUCT, "geometry");
		registerFunction("dimension", new SpatialRelateFunction("st_dimension", Types.INTEGER));
		registerFunction("geometrytype", new StandardSQLFunction("st_geometrytype", Types.STRING));
		registerFunction("srid", new StandardSQLFunction("st_srid", Types.INTEGER));
		registerFunction("envelope", new SpatialRelateFunction("st_envelope", Types.GEOMETRY));
		registerFunction("astext", new SpatialRelateFunction("st_astext", Types.STRING));
		registerFunction("asbinary", new SpatialRelateFunction("st_asbinary", Types.BINARY));
		registerFunction("isempty", new SpatialRelateFunction("st_isempty", Types.BOOLEAN));
		registerFunction("issimple", new SpatialRelateFunction("st_issimple", Types.BOOLEAN));
		registerFunction("boundary", new SpatialRelateFunction("st_boundary", Types.GEOMETRY));

		// Register functions for spatial relation constructs
		registerFunction("overlaps", new SpatialRelateFunction("st_overlaps", Types.BOOLEAN));
		registerFunction("intersects", new SpatialRelateFunction("st_intersects", Types.BOOLEAN));
		registerFunction("equals", new SpatialRelateFunction("st_equals", Types.BOOLEAN));
		registerFunction("contains", new SpatialRelateFunction("st_contains", Types.BOOLEAN));
		registerFunction("crosses", new SpatialRelateFunction("st_crosses", Types.BOOLEAN));
		registerFunction("disjoint", new SpatialRelateFunction("st_disjoint", Types.BOOLEAN));
		registerFunction("touches", new SpatialRelateFunction("st_touches", Types.BOOLEAN));
		registerFunction("within", new SpatialRelateFunction("st_within", Types.BOOLEAN));
		registerFunction("relate", new SpatialRelateFunction("st_relate", Types.BOOLEAN));

		// register the spatial analysis functions
		registerFunction("distance", new SpatialRelateFunction("st_distance", Types.DOUBLE));
		registerFunction("buffer", new SpatialRelateFunction("st_buffer", Types.GEOMETRY));
		registerFunction("convexhull", new SpatialRelateFunction("st_convexhull", Types.GEOMETRY));
		registerFunction("difference", new SpatialRelateFunction("st_difference", Types.GEOMETRY));
		registerFunction("intersection", new SpatialRelateFunction("st_intersection", Types.GEOMETRY));
		registerFunction("symdifference", new StandardSQLFunction("st_symdifference", Types.GEOMETRY));
		registerFunction("geomunion", new SpatialRelateFunction("st_union", Types.GEOMETRY));

		// register Spatial Aggregate function
		registerFunction("extent", new SpatialRelateFunction("extent", Types.GEOMETRY));

		// other common functions
		registerFunction("dwithin", new SpatialRelateFunction("st_dwithin", Types.BOOLEAN));
		registerFunction("transform", new SpatialRelateFunction("st_transform", Types.GEOMETRY));

		registerFunction("mbrintersects", new SpatialRelateFunction("st_transform", Types.GEOMETRY));
	}

	public String getSpatialRelateSQL(String columnName, int spatialRelation) {
		switch (spatialRelation) {
		case SpatialRelation.WITHIN:
			return " ST_within(" + columnName + ",?)";
		case SpatialRelation.CONTAINS:
			return " ST_contains(" + columnName + ", ?)";
		case SpatialRelation.CROSSES:
			return " ST_crosses(" + columnName + ", ?)";
		case SpatialRelation.OVERLAPS:
			return " ST_overlaps(" + columnName + ", ?)";
		case SpatialRelation.DISJOINT:
			return " ST_disjoint(" + columnName + ", ?)";
		case SpatialRelation.INTERSECTS:
			return " ST_intersects(" + columnName + ", ?)";
		case SpatialRelation.TOUCHES:
			return " ST_touches(" + columnName + ", ?)";
		case SpatialRelation.EQUALS:
			return " ST_equals(" + columnName + ", ?)";
		default:
			throw new IllegalArgumentException("Spatial relation is not known by this dialect");
		}
	}

	public String getDWithinSQL(String columnName) {
		return "ST_DWithin(" + columnName + ",?,?)";
	}

	public String getHavingSridSQL(String columnName) {
		return "( ST_srid(" + columnName + ") = ?)";
	}

	public String getIsEmptySQL(String columnName, boolean isEmpty) {
		String emptyExpr = " ST_IsEmpty(" + columnName + ") ";
		return isEmpty ? emptyExpr : "( NOT " + emptyExpr + ")";
	}

	public String getSpatialFilterExpression(String columnName) {
		return "(" + columnName + " && ? ) ";
	}
	*/
	
	
	public void setFetchSize(Connection connection, PreparedStatement preparedStatement, Integer fetchSize) throws SQLException {
        // TODO Auto-generated method stub
	    connection.setAutoCommit(false);
        preparedStatement.setFetchSize(fetchSize);
        preparedStatement.setFetchDirection(ResultSet.FETCH_FORWARD);
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.dialect.db.SQLDialect#getDefaultSchema()
     */
    @Override
    public String getDefaultSchema() {
        // TODO Auto-generated method stub
        return KET_WORD_DEFAULT_SCHEMA;
    }

    /* (non-Javadoc)
     * @see com.northpool.resources.dialect.db.SQLDialect#isFieldSerial(java.lang.String)
     */
    @Override
    public Boolean isFieldSerial(String columnTypeName) {
        // TODO Auto-generated method stub
        if(KEY_WORD_SERIAL.equalsIgnoreCase(columnTypeName)){
            return true;
        }
        return false;
    }

    

   protected boolean defaultValueIsSequence(String columnTypeName,String defaultValue){
       /**
        * 如果已经是自增字段，则不需要用序列
        */
       if(isFieldSerial(columnTypeName)){
           return false;
       }
       if(defaultValue == null){
           return false;
       }
       if(defaultValue.startsWith("nextval(") && defaultValue.endsWith("::regclass)")){
           return true;
       }
       if(defaultValue.startsWith("nextval(".toUpperCase()) && defaultValue.endsWith("::regclass".toUpperCase())){
           return true;
       }
       return false;
   }
    
   protected boolean defaultValueIsFuntion(String columnTypeName,String defaultValue){
       /**
        * 如果已经是自增字段，则不需要用序列
        */
       if(isFieldSerial(columnTypeName)){
           return false;
       }
       return StringUtility.isFunction(defaultValue);
   }
    
   protected boolean defaultValueIsNowDate(String columnTypeName,String defaultValue){
       if(KEY_WORD_NOW_DATE.equalsIgnoreCase(defaultValue) || KEY_WORD_CURRENT_TIMESTAMP.equalsIgnoreCase(defaultValue)){
           return true;
       }
       return false;
   }


   public String createSequenceName(String schema, String tableName, String fieldName) {
       // TODO Auto-generated method stub
       StringBuilder seqName = new StringBuilder();
       if(schema == null || KET_WORD_DEFAULT_SCHEMA.equalsIgnoreCase(schema)){
           
       }else{
           seqName.append(schema.toLowerCase()).append("_");
       }
       seqName.append(tableName).append("_");
       seqName.append(fieldName).append("_seq");
       return seqName.toString();
   }
    
  
    @Override
    public String hasSequenceSql(String sequenceName) {
        String sql = "select relname from pg_class where relname = ?";
        return sql;
    }
    
   
    @Override
    public String getCreateSequenceSQL(String sequenceName) {
        // TODO Auto-generated method stub
        StringBuilder sql = new StringBuilder("CREATE SEQUENCE ") .append(sequenceName).append(" ")
            .append("INCREMENT 1 ")
            .append("MINVALUE 0 ")
            .append("MAXVALUE 9223372036854775807 ")
            .append("START 0 ")
            .append("CACHE 1 ");

        return sql.toString();
    }

   
    @SuppressWarnings("unchecked")
    @Override
    public ICreateTableFieldRefDialect<List<String>,String> getCreateTableFieldRefDialect() {
        return PostgresFieldRefDialect.INSTANCE;
    }

   
    @Override
    public boolean isColumnSerial(ColumnBean columnBean,String columnTypeName) {
        // TODO Auto-generated method stub
        if(KEY_WORD_SERIAL.equalsIgnoreCase(columnTypeName)){
            return true;
        }
        return false;
    }
    
    public String processTableNameAndSchema(String tableName){
        return tableName;
    }

   
    @SuppressWarnings("unchecked")
    @Override
    public IResourcesDataInput<PreparedStatement,Integer> getResourcesDataDataInput() {
        return resourcesDataInput;
    }

 
    @SuppressWarnings("unchecked")
    @Override
    public IResourcesDataOutput<ResultSet,Integer> getResourcesDataOutput() {
        return resourcesDataOutput;
    }

   

    


}
