/**
　 * <p>Title: PostgresSQLResourcesDataInput.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年6月24日
　 * @version 1.0
*/
package com.northpool.resources.dialect.db.postgresql;

import java.sql.PreparedStatement;
import java.sql.Types;

import org.postgresql.util.PGobject;

import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.dialect.IResourcesDataInput;
import com.northpool.resources.dialect.ResourcesDataInputException;
import com.northpool.resources.dialect.db.AbstractResourcesDataInput;
import com.northpool.spatial.Geom;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.postgresql.HexWkbDecoder;
import com.northpool.type.TypePostGisGeometry;

/**
 * @author matt
 *
 */
public class PostgresSQLResourcesDataInput extends AbstractResourcesDataInput implements IResourcesDataInput<PreparedStatement,Integer>{

    static final String POSTGIS_GEOMETRY_NAME = "geometry";
    
    @Override
    public DATA_SOURCE_TYPE getDataSourceType() {
        return DATA_SOURCE_TYPE.postgreSQL;
    }

   
    @Override
    public void columnGeometry(PreparedStatement input, Object value, Integer indexOrLabelName) throws Exception {
        if(value == null){
            input.setNull(indexOrLabelName,  Types.JAVA_OBJECT);
            return;
        }
        if(value instanceof Geom){
            Geom geom = (Geom)value;
            TypePostGisGeometry.INSTANCE.isType(geom);
            PGobject po = new PGobject();
            po.setType(POSTGIS_GEOMETRY_NAME);
           
            po.setValue((String)geom.getOriginGeom());
            input.setObject(indexOrLabelName, po);
         }else{
             throw new ResourcesDataInputException(this.getDataSourceType(),TypePostGisGeometry.INSTANCE,value,"值类型不符");
         }
    }

}
