package com.northpool.resources.sql.jdbc;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import org.apache.commons.lang3.StringUtils;

import com.northpool.exception.UException;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.resources.sql.IDML;
import com.northpool.type.Type;
import com.northpool.resources.sql.IBatchDataScroll;

public class JDBCUpdate extends AbstractsJDBCCell<Void> implements IDML{ 
	
	protected int batchSize = 40;

	public JDBCUpdate(IDataSource dataSource, ISQLDialect dialect,String sql)  {
		super(dataSource, dialect, sql);
		// TODO Auto-generated constructor stub
	}

	/*@Override
	public Update setResultTransformer(Transformer<?> transformer) {
		// TODO Auto-generated method stub
		this.transformer = (SQLTransformer<?>) transformer;
		return this;
	}*/
	
	protected void printSQL(Object[] args,Integer batchSize){
	    if(batchSize != null){
            logger.debug(this.sql);
            logger.debug("use parameters:" + StringUtils.join(args, ","));
	    }else{
	        logger.debug(this.sql);
	        logger.debug("use parameters size " + batchSize);
	    }
    }
	
	public void update(final Object[] args) throws DataAccessException {
	    
        try {
            this.execute((Connection con) ->{
                return this.prepareUpdateStatement(con);
            }, (PreparedStatement ps) ->{
                try {
                    if(args != null){
                        this.setValues(ps, args,this.inputTypes.toArray(new Type[this.inputTypes.size()]));
                    }
                    ps.execute();
                } catch (Exception e) {
                    Boolean isAutoCommit = ps.getConnection().getAutoCommit();
                    if(!isAutoCommit){
                        ps.getConnection().rollback();
                    }
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                
                return 1;
            });
        } catch (SQLException e) {
            // TODO Auto-generated catch block
            throw new DataAccessException(e);
        }
        
	}
	

	@Override
	public void batchUpdate(final IBatchDataScroll scroll) throws DataAccessException {
		
        try {
            this.execute((Connection con) ->{
            	return this.prepareUpdateStatement(con);
            }, (PreparedStatement ps) ->{
            	try {
            		int index = 0;
            		while(scroll.hasNext()){
            			Object[] args = scroll.next();
            			this.setValues(ps, args,this.inputTypes.toArray(new Type[this.inputTypes.size()]));
            			ps.addBatch();
            			if ((index + 1) % this.batchSize == 0) {
            		        ps.executeBatch();
            		    }
            			index ++;
            		}
            		if (scroll.size() % batchSize != 0) {
            		    ps.executeBatch();
            		}
            	
            	} catch (Exception e) {
            		Boolean isAutoCommit = ps.getConnection().getAutoCommit();
            		if(!isAutoCommit){
            			ps.getConnection().rollback();
            		}
            		UException.printStackTrace(e);
            		throw new SQLException(e);
            	}
            	
            	return 1;
            });
        } catch (SQLException e) {
            // TODO Auto-generated catch block
            throw new DataAccessException(e);
        }
        
	}

	
	@Override
	public IDML setBatchSize(int batchSize) {
		// TODO Auto-generated method stub
		this.batchSize = batchSize;
		return this;
	}

	
	protected final PreparedStatement prepareUpdateStatement(Connection connection) throws SQLException{
		
		PreparedStatement preparedStatement = connection.prepareStatement(this.sql);
		//如果没有事务，则设置自动提交
		if(connection.getTransactionIsolation() == Connection.TRANSACTION_NONE){
			connection.setAutoCommit(true);
		}
		
		return preparedStatement;
	}

  
	@Override
    public void insert(Object[] args) throws DataAccessException {
        // TODO Auto-generated method stub
        this.update(args);
    }

  
    @Override
    public void batchInsert(IBatchDataScroll scroll) throws DataAccessException {
        // TODO Auto-generated method stub
        this.batchInsert(scroll);
    }

   
	


}
