/**
　 * <p>Title: IDSQLTransformer.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年10月19日
　 * @version 1.0
*/
package com.northpool.resources.sql.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.LinkedHashMap;
import java.util.Map;

import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.resources.sql.ResultSetMapping;
import com.northpool.type.Type;

/**
 * @author matt
 *
 */
public class OneFiledJDBCTransformer  extends AbstractsJDBCTransformer<Object> implements IJDBCTransformer<Object> {

   
    
    
    @Override
    protected ResultSetMapping<Object,ResultSet> getMapping() {
        // TODO Auto-generated method stub
        return new ResultSetMapping<Object,ResultSet>(){
            @Override
            public Object mapping(ResultSet rs, LinkedHashMap<String, Type> typeMap,final IDialect dialect) {
                // TODO Auto-generated method stub
                ResultSetMetaData rsmd;
                try {
                    rsmd = rs.getMetaData();
                    String name = rsmd.getColumnLabel(1);
                    Type type = typeMap.get(name);
                    Object value = null;
                    IResourcesDataOutput<ResultSet,Integer> output = dialect.getResourcesDataOutput();
                    value = output.output(rs, type, 1);
                    return value;
                } catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
            }
        };
    }

}
