package com.northpool.spatial.postgresql;

import java.io.ByteArrayInputStream;

import org.locationtech.jts.io.ByteOrderValues;
import org.locationtech.jts.io.WKBConstants;

import com.northpool.spatial.AGeomDecoder;
import com.northpool.spatial.ByteOrderDataInStream;
import com.northpool.spatial.GeomDecoder;
import com.northpool.spatial.GeometryInfo;
import com.northpool.spatial.Constants.GEO_TYPE;
import com.northpool.spatial.Constants.SPATIAL_TYPE;
import com.northpool.spatial.geofeature.GeoBuffer;
import com.northpool.spatial.wkb.AbstractWkbDecoder;

@AGeomDecoder(type = SPATIAL_TYPE.hexwkb)
public class HexWkbDecoder extends AbstractWkbDecoder implements GeomDecoder<String> {

	public static final HexWkbDecoder DECODER = new HexWkbDecoder();
	
	@Override
	public GeoBuffer toGeoBuffer(String hex) throws Exception {
		
	    ByteArrayInputStream instream = new ByteArrayInputStream(hex.getBytes());
		
		ByteOrderDataInStream dis = new ByteOrderDataInStream(instream,true);
		
	    byte byteOrderWKB = dis.readByte();
	    // always set byte order, since it may change from geometry to geometry
		int byteOrder = byteOrderWKB == WKBConstants.wkbNDR ? ByteOrderValues.LITTLE_ENDIAN : ByteOrderValues.BIG_ENDIAN;
		dis.setOrder(byteOrder);
		
		int typeInt = dis.readInt();
		GeometryInfo info = new GeometryInfo();
		info.setGeometryType( typeInt  & 0x1FFFFFFF);
	    // determine if Z values are present
		info.setHasZ((typeInt & 0x80000000) != 0);
		info.setHasM((typeInt & 0x40000000) != 0);
		boolean haveSrid = (typeInt & 0x20000000) != 0;
		int srid = 0;
		if (haveSrid) {
			srid = dis.readInt();
		}
		
		
		int size = instream.available();
		
		GEO_TYPE geoType = is(info.getGeometryType());
		
		int inputDimension = info.hasZ() ? 3 : 2;

		GeoBuffer geo = new GeoBuffer(geoType,srid,inputDimension);
		
		return this.process(geoType, dis, geo, info);
	}
	
	
	
	
}
