/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.sql.jdbc;

import com.northpool.resources.Constants;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.resources.sql.IBatchDataScroll;
import com.northpool.resources.sql.IDML;
import com.northpool.resources.sql.IQuery;
import com.northpool.resources.sql.jdbc.IJDBCGenericDao;
import com.northpool.resources.sql.jdbc.IJDBCTransformer;
import com.northpool.resources.sql.jdbc.JDBCQuery;
import com.northpool.resources.sql.jdbc.JDBCUpdate;
import com.northpool.resources.sql.jdbc.ProcedureParamCell;
import com.northpool.type.Type;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class JDBCGenericDaoImpl
implements IJDBCGenericDao {
    protected IDataSource dataSource;
    protected ISQLDialect dialect;

    public JDBCGenericDaoImpl(IDataSource dataSource) {
        this.dataSource = dataSource;
        this.dialect = (ISQLDialect)IDialect.getByType((Constants.DATA_SOURCE_TYPE)dataSource.getDataSourceType());
    }

    protected <T> IQuery<T, IJDBCTransformer<?>> createSQLQuery(String sql, Object[] args, Type[] types, Integer firstResult, Integer maxResults, Map<String, Type> returnType, IJDBCTransformer<T> transformer) throws DataAccessException {
        IQuery<T, IJDBCTransformer<?>> query = this.SQLQuery(sql);
        query.setResultTransformer(transformer);
        query.addScalar(returnType);
        if (args != null) {
            Type[] inTypes = types == null ? this.guessType(args) : types;
            query.setInputTypes(inTypes);
            query.setParameters(args);
        }
        query.setFirstResult(firstResult).setMaxResults(maxResults);
        return query;
    }

    private Type[] guessType(Object[] args) {
        Type[] types = new Type[args.length];
        for (int i = 0; i < args.length; ++i) {
            Type t;
            Object arg = args[i];
            types[i] = t = this.dialect.getTypeByObject(arg);
        }
        return types;
    }

    private IDML createSQLUpdate(String sql, Type[] types, Integer batchSize) {
        IDML update = this.SQLUpdate(sql);
        update.setInputTypes(types);
        if (batchSize != null) {
            update.setBatchSize(batchSize.intValue());
        }
        return update;
    }

    @Override
    public <T> List<T> queryBySql(String sql, Object[] objs, Type[] types, Map<String, Type> returnTypes, Integer firstResult, Integer maxResults, Integer fetchSize, IJDBCTransformer<T> transformer) throws DataAccessException {
        IQuery<T, IJDBCTransformer<?>> query = this.createSQLQuery(sql, objs, types, firstResult, maxResults, returnTypes, transformer);
        if (fetchSize != null) {
            query.setFetchSize(fetchSize);
        }
        List i = query.list();
        return i;
    }

    @Override
    public <T> IScroll<T> scrollBySql(String sql, Object[] objs, Type[] types, Map<String, Type> returnTypes, Integer firstResult, Integer maxResults, Integer fetchSize, IJDBCTransformer<T> transformer) {
        IQuery<T, IJDBCTransformer<?>> query = this.createSQLQuery(sql, objs, types, firstResult, maxResults, returnTypes, transformer);
        query.setFetchSize(fetchSize);
        return query.scroll();
    }

    @Override
    public void doBatchExecuteSql(String sql, final List<Object[]> datas, Type[] types, Integer batchSize) throws DataAccessException {
        if (types == null) {
            throw new DataAccessException("types\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        IBatchDataScroll scroll = new IBatchDataScroll(){
            Iterator<Object[]> iterator;
            {
                this.iterator = datas.iterator();
            }

            public boolean hasNext() {
                return this.iterator.hasNext();
            }

            public Object[] next() {
                return this.iterator.next();
            }

            public int size() {
                return datas.size();
            }
        };
        this.doBatchExecuteSql(sql, types, scroll, batchSize);
    }

    protected void doBatchExecuteSql(String sql, Type[] types, IBatchDataScroll scroll, Integer batchSize) throws DataAccessException {
        IDML update = this.createSQLUpdate(sql, types, batchSize);
        update.batchUpdate(scroll);
    }

    @Override
    public void doExecuteSql(String sql, Object[] datas, Type[] types) throws DataAccessException {
        Type[] typeArr = null;
        if (datas != null) {
            if (types == null) {
                typeArr = this.guessType(datas);
            } else {
                if (datas.length != types.length) {
                    throw new DataAccessException("\u53c2\u6570datas\u7684\u957f\u5ea6\u5fc5\u987b\u548ctypes\u7684\u957f\u5ea6\u4e00\u81f4");
                }
                typeArr = types;
            }
        }
        IDML update = this.createSQLUpdate(sql, typeArr, null);
        update.update(datas);
    }

    @Override
    public void doExecuteSql(String sql) throws DataAccessException {
        this.doExecuteSql(sql, null, null);
    }

    @Override
    public Long getCountBySql(String querySql, Object[] objs, Type[] types) {
        String sql;
        IQuery<Object, IJDBCTransformer<?>> query;
        List i;
        int orderByIndex = querySql.toUpperCase().indexOf(" ORDER BY ");
        if (orderByIndex != -1) {
            querySql = querySql.substring(0, orderByIndex);
        }
        if ((i = (query = this.createSQLQuery(sql = "select count(*) as count from (" + querySql + ") tmp_count_t", objs, types, -1, -1, null, IJDBCTransformer.ONEFILED)).list()).isEmpty()) {
            return null;
        }
        return (Long)i.get(0);
    }

    @Override
    public Object[] excuteProcedure(String procedureName, ProcedureParamCell ... params) {
        return null;
    }

    protected <T> IQuery<T, IJDBCTransformer<?>> SQLQuery(String sql) {
        return new JDBCQuery(this.dataSource, this.dialect, sql);
    }

    protected IDML SQLUpdate(String sql) {
        return new JDBCUpdate(this.dataSource, this.dialect, sql);
    }

    @Override
    public List<Map<String, Object>> queryBySql(String sql, Object[] objs) throws DataAccessException {
        return this.queryBySql(sql, objs, null, null, -1, -1, null, IJDBCTransformer.MAP);
    }
}

