/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.sql.jdbc;

import com.northpool.exception.UException;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.resources.sql.IBatchDataScroll;
import com.northpool.resources.sql.IDML;
import com.northpool.resources.sql.jdbc.AbstractsJDBCCell;
import com.northpool.type.Type;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;

public class JDBCUpdate
extends AbstractsJDBCCell<Void>
implements IDML {
    protected int batchSize = 40;

    public JDBCUpdate(IDataSource dataSource, ISQLDialect dialect, String sql) {
        super(dataSource, dialect, sql);
    }

    protected void printSQL(Object[] args, Integer batchSize) {
        if (batchSize != null) {
            logger.debug(this.sql);
            logger.debug("use parameters:" + StringUtils.join((Object[])args, (String)","));
        } else {
            logger.debug(this.sql);
            logger.debug("use parameters size " + batchSize);
        }
    }

    public void update(Object[] args) throws DataAccessException {
        try {
            this.execute(con -> this.prepareUpdateStatement(con), ps -> {
                try {
                    if (args != null) {
                        this.setValues(ps, args, this.inputTypes.toArray(new Type[this.inputTypes.size()]));
                    }
                    ps.execute();
                }
                catch (Exception e) {
                    Boolean isAutoCommit = ps.getConnection().getAutoCommit();
                    if (!isAutoCommit.booleanValue()) {
                        ps.getConnection().rollback();
                    }
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                return 1;
            });
        }
        catch (SQLException e) {
            throw new DataAccessException((Exception)e);
        }
    }

    public void batchUpdate(IBatchDataScroll scroll) throws DataAccessException {
        try {
            this.execute(con -> this.prepareUpdateStatement(con), ps -> {
                try {
                    int index = 0;
                    while (scroll.hasNext()) {
                        Object[] args = scroll.next();
                        this.setValues(ps, args, this.inputTypes.toArray(new Type[this.inputTypes.size()]));
                        ps.addBatch();
                        if ((index + 1) % this.batchSize == 0) {
                            ps.executeBatch();
                        }
                        ++index;
                    }
                    if (scroll.size() % this.batchSize != 0) {
                        ps.executeBatch();
                    }
                }
                catch (Exception e) {
                    Boolean isAutoCommit = ps.getConnection().getAutoCommit();
                    if (!isAutoCommit.booleanValue()) {
                        ps.getConnection().rollback();
                    }
                    UException.printStackTrace((Throwable)e);
                    throw new SQLException(e);
                }
                return 1;
            });
        }
        catch (SQLException e) {
            throw new DataAccessException((Exception)e);
        }
    }

    public IDML setBatchSize(int batchSize) {
        this.batchSize = batchSize;
        return this;
    }

    protected final PreparedStatement prepareUpdateStatement(Connection connection) throws SQLException {
        PreparedStatement preparedStatement = connection.prepareStatement(this.sql);
        if (connection.getTransactionIsolation() == 0) {
            connection.setAutoCommit(true);
        }
        return preparedStatement;
    }

    public void insert(Object[] args) throws DataAccessException {
        this.update(args);
    }

    public void batchInsert(IBatchDataScroll scroll) throws DataAccessException {
        this.batchInsert(scroll);
    }
}

