package com.northpool.resources.datatable.db.operate;

import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datatable.db.operate.column.OracleColumn;
import com.northpool.resources.datatable.operate.ATableOperator;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.datatable.operate.IIndex;
import com.northpool.resources.datatable.operate.Index;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.resources.sql.jdbc.IJDBCTransformer;
import com.northpool.spatial.Constants;
import com.northpool.spatial.Constants.GEO_TYPE;
import com.northpool.spatial.Constants.SPATIAL_UNIT;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

@ATableOperator(name = "oracle", type = DATA_SOURCE_TYPE.oracle)

public class OracleTableOperator extends AbstractDBTableOperator implements IDBTableOperator {

	//private GeometryOracleConverter goc;


	//	goc = new GeometryOracleConverter(this.getConnection());


	/*@Override
	protected DATA_BASE_TYPE processDataBaseType() {
		return DATA_BASE_TYPE.oracle;
	}*/

	@Override
	protected void processTableNameAndSchema(String tableName, String schema, Boolean isCaseSensitive) {

		if (tableName.contains(".")) {// 若表名含有. 则按.进行分割，分割为schema 和 tableName
			String[] arr = tableName.split("\\.");
			tableName = arr[1];
			schema = arr[0];
		}
		DbDataSource dbDataSource = (DbDataSource)this.dataSource;
		if (schema == null) {
			schema = dbDataSource.getUser();
		}
		this.tableName = tableName.toUpperCase();
		this.schema = schema.toUpperCase();
		if (isCaseSensitive) {
            tableName = tableName.toLowerCase();
            schema = schema.toLowerCase();
        }
	}

	@Override
	protected String getRemarks(ResultSet columns) throws SQLException {
		return columns.getString(REMARKS);
	}

	@Override
	protected ResultSet getColumns(DatabaseMetaData dbmd, String tableName, String schema) throws SQLException {
		ResultSet columns = dbmd.getColumns(null, this.schema, this.tableName.replace("\"", ""), null);
		return columns;
	}

	@Override
	protected IColumn createColumn(String columnName, Integer columnSize, Integer digits,
			String columnTypeName, Boolean nullable, String defaultValue, String colRemarks) {
		OracleColumn column = new OracleColumn(columnName, columnSize, digits, columnTypeName, nullable,
		    defaultValue, colRemarks, (ISQLDialect)this.dialect);
		return column;
	}
	@Override
	public CompletableFuture<Object> dropIndex(final String indexName) {
		IIndex index = this.indexMap.get(indexName);
		if(index == null){
			DatabaseMetaData dbmd;
			try {
				dbmd = this.dbconn.getMetaData();
				index = this.getIndexInfo(dbmd).get(indexName);
			} catch (SQLException e) {
				// TODO Auto-generated catch block
				e.printStackTrace();
				throw new RuntimeException(e);
			}
		}
		if(index == null){
			return null;
		}else{
			if(index.getSpatial()){
				String sql = "delete from SDO_GEOM_METADATA_TABLE where SDO_TABLE_NAME = ? and SDO_COLUMN_NAME = ?";
				this.genericDao.doExecuteSql(sql, new Object[]{this.tableName,index.getColname()},null);
			}
		}
		return super.dropIndex(indexName);

	}


	@Override
	protected CompletableFuture<Object> createSpatialIndex(String colname) {

		Integer srid = this.getSRID(colname);

		SPATIAL_UNIT unit = Constants.getSpatialUnitBySRID(srid);

		// 插入源数据表
		final StringBuffer inster = new StringBuffer();
		inster.append("INSERT INTO SDO_GEOM_METADATA_TABLE");
		inster.append("(SDO_OWNER,SDO_TABLE_NAME,SDO_COLUMN_NAME,SDO_DIMINFO,SDO_SRID)");
		inster.append(" VALUES  (");
		inster.append(this.schema);
		inster.append(this.tableName);
		inster.append(colname);
		//先这样写，以后再改需要根据srid区别单位是经纬度还是米
		if(unit == SPATIAL_UNIT.degree){
			inster.append("MDSYS.SDO_DIM_ARRAY (").append("MDSYS.SDO_DIM_ELEMENT('X', -180.0, 180.0, 0.005),")
					.append("MDSYS.SDO_DIM_ELEMENT('Y', -90.0,90.0, 0.005))");
		}else{
			inster.append("MDSYS.SDO_DIM_ARRAY (").append("MDSYS.SDO_DIM_ELEMENT('X', -20037508, 20037508, 0.5),")
			.append("MDSYS.SDO_DIM_ELEMENT('Y', -20037508,20037508, 0.5))");
		}
		inster.append(srid);
		inster.append(")");
		this.genericDao.doExecuteSql(inster.toString(), null ,null);

		CompletableFuture<Object> promise = CompletableFuture.supplyAsync(() -> {
			logger.info(mark() + "_" + colname + "创建空间索引");
			String indexName = this.createSpatialIndexName(colname);
			// CREATE INDEX 索引名称 ON 表名 (字段名称) INDEXTYPE IS MDSYS.SPATIAL_INDEX;
			String sql = "CREATE INDEX " + indexName + " ON " + this.tableName + "(" + colname
					+ ") INDEXTYPE IS MDSYS.SPATIAL_INDEX;";
			logger.info("execute sql" + sql);
			this.genericDao.doExecuteSql(sql, null,null);
			Index index = new Index();
			index.setName(indexName);
			index.setUnique(false);
			index.isSpatial(true);
			index.setColname(colname);
			this.addToIndexMap(colname, index);
			return null;
		});
		return promise;
	}

	@Override
	protected Object[] getSpatialInfo(String colunmName) throws SQLException {
		String sql = "SELECT SRID FROM USER_SDO_GEOM_METADATA WHERE TABLE_NAME = ?";
		List<Map<String,Object>> i = this.genericDao.queryBySql(sql, new Object[]{colunmName}, null, null, null, null, null,  IJDBCTransformer.MAP);
		if(i.isEmpty()){
			return null;
		}else{
			Map<String,Object> data = i.get(0);
			Integer srid = (Integer) data.get("SRID");
			return new Object[] { srid, GEO_TYPE.GEOMETRY };
		}
	}

	@Override
	protected String getCataLog() throws SQLException {
		return null;
	}

	@Override
	protected void getTableInfo(DatabaseMetaData dbmd, String tableName) throws SQLException {

		try (ResultSet resultSet = dbmd.getTables(null, this.schema, this.tableName,
				new String[] { "TABLE", "VIEW" });) {
			boolean isNull = true;
			while (resultSet.next()) {
				isNull = false;
				String type = resultSet.getString("TABLE_TYPE");
				this.tableRemarks = resultSet.getString("REMARKS");
				if (!"TABLE".equalsIgnoreCase(type)) {
					this.isView = true;
				}
			}

			if (isNull) {
				throw new RuntimeException("表/视图" + this.schema + "." + tableName + "不存在");
			}
			resultSet.close();
		}

	}


	protected LinkedHashMap<String,IIndex> getIndexInfo(DatabaseMetaData dbmd) throws SQLException{
		LinkedHashMap<String,IIndex> map = new LinkedHashMap<String,IIndex>();
		if(this.isView){

		}else{
			ResultSet indexes = dbmd.getIndexInfo(this.cataLog, this.schema, this.tableName, false, true);
			while(indexes.next()){
				String indname = indexes.getString("INDEX_NAME");
				String asc = indexes.getString("ASC_OR_DESC");
				boolean nonunique = indexes.getBoolean("NON_UNIQUE");
				String colname = indexes.getString("COLUMN_NAME");
				Index index = new Index();
				index.setAsc(asc);
				index.setName(indname);
				index.setUnique(!nonunique);
				index.addColname(colname);
				IColumn column = this.columnMap.get(colname);
				if(column != null){
					if(column.isSpatial()){
						index.setSpatial(true);
					}
				}
				map.put(indname, index);
			}
			indexes.close();
		}
		return map;
	}

/*
	@Override
	protected GeoBuffer getGeoBufferInfoByData(String colunmName) throws SQLException{
		return null;
	}
*/



/*	@Override
	protected void buildColumns(DatabaseMetaData dbmd,String tableName,String schema) throws SQLException{


//		if(columns.wasNull()){
//			throw new RuntimeException(schema + "." + tableName + "获取列失败");
//		}
//		String[] types = new String[1];
		List<String> tmp = new ArrayList<String>();

		try (ResultSet columns = this.getColumns(dbmd, tableName, schema);) {
			Set<String> colnameSet = new HashSet<String>();
			boolean isNull = true;
			while (columns.next()) {
				isNull = false;
				String columName = columns.getString(COLUMN_NAME);
				colnameSet.add(columName);
				Short columType = columns.getShort(DATA_TYPE);
				Integer columSize = columns.getInt(COLUMN_SIZE);
				Integer digits = 0;
				String columTypeName = columns.getString(TYPE_NAME);
				Boolean nullable = false;
				Boolean withDefault = false;

				if ((columType == 3) || (columType == 2)) {
					digits = columns.getInt(DECIMAL_DIGITS);
				}

				if (columns.getInt(NULLABLE) == 1)
					nullable = true;
				else {
					nullable = false;
				}
				withDefault = columns.getString(COLUMN_DEF) != null;
				String colRemarks = this.getRemarks(columns);

				IColumn column = this.createColumn(columName, columSize, digits, columTypeName, nullable, withDefault, colRemarks);

				this.columnMap.put(column.getColumnName(), column);
				tmp.add(column.getColumnName());

			}

			if (isNull) {
				throw new RuntimeException(schema + "." + tableName + "获取列失败");
			}
			this.columnArray = tmp.toArray(new String[tmp.size()]);

			columns.close();
		}


	}*/




}