package com.northpool.resources.datatable.db.operate;

import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

//import com.northpool.resources.Constants.DATA_BASE_TYPE;
import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datatable.AbstractTable;
import com.northpool.resources.datatable.db.operate.column.PostgresColumn;
import com.northpool.resources.datatable.operate.ATableOperator;
import com.northpool.resources.datatable.operate.IColumn;
import com.northpool.resources.datatable.operate.Index;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.resources.sql.jdbc.IJDBCTransformer;
import com.northpool.spatial.Constants.GEO_TYPE;

@ATableOperator(name = "postgresql", type = DATA_SOURCE_TYPE.postgreSQL)

public class PostgresTableOperator extends AbstractDBTableOperator implements IDBTableOperator {
 
	
	
	
	protected final static String  DEFAULT_PG_SCHEMA = "public";
	
	/*@Override
	protected DATA_BASE_TYPE processDataBaseType() {
		// TODO Auto-generated method stub
		return DATA_BASE_TYPE.postgreSQL;
	}*/

	@Override
	protected void processTableNameAndSchema(String tableName, String schema,Boolean isCaseSensitive) {
		
		if (tableName.contains(".")){//若表名含有. 则按.进行分割，分割为schema 和 tableName
			String[] arr = tableName.split("\\.");
			tableName = arr[1];
			schema = arr[0];
		}
		if(schema == null){
			schema = DEFAULT_PG_SCHEMA;
		}
		if(!isCaseSensitive){
            tableName = tableName.toLowerCase();
            schema = schema.toLowerCase();
        }
		this.tableName = tableName;
		this.schema = schema;
		
	} 
 
	

	@Override
	protected String getRemarks(ResultSet columns) throws SQLException {
		return columns.getString(REMARKS);
	}

	@Override
	protected ResultSet getColumns(DatabaseMetaData dbmd, String tableName, String schema) throws SQLException {
		ResultSet columns = dbmd.getColumns(this.cataLog, this.schema, this.tableName.replace("\"", ""), null);
		return columns;
	}

	@Override
	protected IColumn createColumn(String columnName, Integer columnSize, Integer digits,
			String columnTypeName, Boolean nullable, String defaultValue, String remarks) {
		PostgresColumn column = new PostgresColumn( columnName,  columnSize,  digits,
			 columnTypeName,  nullable,  defaultValue,  remarks,(ISQLDialect)this.dialect);
		return column;
	}

	//@Override
/*	protected void buildIndexInfo(DatabaseMetaData dbmd) {
		// TODO Auto-generated method stub
		
	}*/

	
	@Override
	protected Object[] getSpatialInfo(String colunmName) throws SQLException{
		String sql = "select srid,type from geometry_columns where f_table_catalog = ? and f_table_schema = ? and f_table_name = ? and f_geometry_column = ?";
		List<Map<String,Object>> i  = this.genericDao.queryBySql(sql, new Object[]{this.cataLog,this.schema,this.tableName,colunmName}, null,null,null,null,null,IJDBCTransformer.MAP);
		if(i.isEmpty()){
			return null;
		}else{
			Map<String,?> data = i.get(0);
			Integer srid = (Integer)data.get("srid");
			String type = (String)data.get("type");
			GEO_TYPE gtype = GEO_TYPE.GEOMETRY;
			GEO_TYPE[] values = GEO_TYPE.values();
			for(GEO_TYPE geo_type : values){
				if(geo_type.name().equalsIgnoreCase(type)){
					gtype = geo_type;
				}
			}
			return new Object[]{srid,gtype};
		}
		
	}
	
	
	
	

	@Override
	protected CompletableFuture<Object> createSpatialIndex(final String colname) {
		// TODO Auto-generated method stub
		String indexName = this.createSpatialIndexName(colname);
		CompletableFuture<Object> promise = CompletableFuture.supplyAsync(()->{
			logger.info(mark() + "_" + colname + "创建空间索引");
			String indexName1 = indexName;
			String tableName = this.tableName;
			String colname1 = colname;
			if(this.dialect.markForTableNameAndColumnName()){
			    tableName = "\"" + tableName + "\"";
                indexName1 = "\"" + indexName1 + "\"";
                colname1 = "\"" + colname1 + "\"";
            }
			String sql = "CREATE INDEX " + indexName1 +  " ON " + tableName + "USING gist (" + colname1 + ");";
			this.genericDao.doExecuteSql(sql, null,null);
			Index index = new Index();
			index.setName(indexName);
			index.setUnique(false);
			index.isSpatial(true);
			index.setColname(colname);
			this.addToIndexMap(colname, index);
			return null;
		});
		return promise;
	}



  



   
	

	

	
	

}
