/**
　 * <p>Title: PostgresFieldRefDialect.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2021年3月31日
　 * @version 1.0
*/
package com.northpool.resources.dialect.db.postgresql;


import java.util.List;

import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.datatable.operate.FieldDefaultValueBean;
import com.northpool.resources.datatable.operate.FieldDefaultValueBean.VALUE_TYPE;
import com.northpool.resources.dialect.ICreateTableFieldRefDialect;
import com.northpool.spatial.Constants.GEO_TYPE;

/**
 * @author matt
 *
 */
public class PostgresFieldRefDialect implements ICreateTableFieldRefDialect<List<String>,String> {

    public static final PostgresFieldRefDialect INSTANCE = new PostgresFieldRefDialect();
    void withNullable(StringBuilder part, ColumnBean bean){
        if(!bean.getNullable()){
            part.append(" NOT NULL ");
        }
    }
    
    void withRemarks(StringBuilder part, ColumnBean bean){
        if(bean.getRemarks() != null){
            ;
        }
    }
    void withDefault(StringBuilder part, ColumnBean bean,String defaultKeyWord){
        FieldDefaultValueBean fieldDefaultValue = bean.getFieldDefaultValue();
        if(fieldDefaultValue != null){
            if(fieldDefaultValue.getType() == VALUE_TYPE.value){
                part.append(" DEFAULT '").append(fieldDefaultValue).append("'").append(defaultKeyWord).append(" ");
            }
            if(fieldDefaultValue.getType() == VALUE_TYPE.function){
                System.out.println("字段默认值不支持函数");
            }
            if(fieldDefaultValue.getType() == VALUE_TYPE.nowDate){
                part.append(" DEFAULT now() ");
            }
            if(fieldDefaultValue.getType() == VALUE_TYPE.sequence){
              //  String sequenceName = fieldDefaultValue.getSequenceName(); 
              //  part.append(" DEFAULT nextval('").append(sequenceName).append("')");
            }
        }
    }
   
    
    
    
  
    @Override
    public String columnBoolean(List<String> builder, ColumnBean bean) {
        // TODO Auto-generated method stub
        StringBuilder part = new StringBuilder();
        String columnName = bean.getColumnName();
        if(PostgreSQLDialect.INSTANCE.markForTableNameAndColumnName()){
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" boolean ");
        withNullable(part,bean);
        withDefault(part,bean,"::boolean");
        builder.add(part.toString());
        return part.toString();
    }

    
  
    
    
    
    @Override
    public String columnBigDecimal(List<String> builder, ColumnBean bean) {
        // TODO Auto-generated method stub
        StringBuilder part = new StringBuilder();
        String columnName = bean.getColumnName();
        if(PostgreSQLDialect.INSTANCE.markForTableNameAndColumnName()){
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" numeric ");
        withNullable(part,bean);
        withDefault(part,bean,"::numeric");
        builder.add(part.toString());
        return part.toString();
        
    }

   
    @Override
    public String columnBytes(List<String> builder, ColumnBean bean) {
        // TODO Auto-generated method stub
        StringBuilder part = new StringBuilder();
        String columnName = bean.getColumnName();
        if(PostgreSQLDialect.INSTANCE.markForTableNameAndColumnName()){
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" bytea ");
        /*if(!bean.getNullable()){
            part.append(" NOT NULL ");
        }
        FieldDefaultValue fieldDefaultValue = bean.getFieldDefaultValue();
        if(fieldDefaultValue != null){
            part.append(" ").append(fieldDefaultValue).append(" ");
        }*/
        withNullable(part,bean);
        builder.add(part.toString());
        return part.toString();
    }

   
    @Override
    public String columnDouble(List<String> builder, ColumnBean bean) {
        StringBuilder part = new StringBuilder();
        String columnName = bean.getColumnName();
        if(PostgreSQLDialect.INSTANCE.markForTableNameAndColumnName()){
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" float8 ");
        withNullable(part,bean);
        withDefault(part,bean,"::float8");
        builder.add(part.toString());
        return part.toString();
    }

  
    @Override
    public String columnGeometry(List<String> builder, ColumnBean bean) {
        StringBuilder part = new StringBuilder();
        Integer srid = bean.getSrid();
        GEO_TYPE geoType = bean.getGeoType();
        String columnName = bean.getColumnName();
        if(PostgreSQLDialect.INSTANCE.markForTableNameAndColumnName()){
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" geometry (").append(geoType.name());
        if(bean.getDimension() == 3){
            part.append("Z"); 
        }
        if(srid != null){
            part.append(",").append(srid);
        }
        part.append(") "); 
        withNullable(part,bean);
        withDefault(part,bean,"::geometry");
        builder.add(part.toString());
        return part.toString();
    }

    
    @Override
    public String columnInteger(List<String> builder, ColumnBean bean) {
        // TODO Auto-generated method stub
        StringBuilder part = new StringBuilder();
        String columnName = bean.getColumnName();
        if(PostgreSQLDialect.INSTANCE.markForTableNameAndColumnName()){
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" ");
        if(bean.getIsSerial()){
            part.append("serial");
        }else{
            part.append("integer");
        }
        withNullable(part,bean);
        withDefault(part,bean,"::integer");
        builder.add(part.toString());
        return part.toString();
    }

    
    @Override
    public String columnLong(List<String> builder, ColumnBean bean) {
        // TODO Auto-generated method stub
        StringBuilder part = new StringBuilder();
        String columnName = bean.getColumnName();
        if(PostgreSQLDialect.INSTANCE.markForTableNameAndColumnName()){
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" ");
        if(bean.getIsSerial()){
            part.append("serial");
        }else{
            part.append("bigint");
        }
        withNullable(part,bean);
        withDefault(part,bean,"::bigint");
        builder.add(part.toString());
        return part.toString();
    }

    
    @Override
    public String columnString(List<String> builder, ColumnBean bean) {
        // TODO Auto-generated method stub
        StringBuilder part = new StringBuilder();
        String columnName = bean.getColumnName();
        if(PostgreSQLDialect.INSTANCE.markForTableNameAndColumnName()){
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" character varying");
        if(bean.getColumnSize() != null){
            part.append("(").append(bean.getColumnSize()).append(")");
        }
        withNullable(part,bean);
        withDefault(part,bean,"::character varying");
        builder.add(part.toString());
        return part.toString();
    }

  
    @Override
    public String columnTimestamp(List<String> builder, ColumnBean bean) {
        // TODO Auto-generated method stub
        StringBuilder part = new StringBuilder();
        String columnName = bean.getColumnName();
        if(PostgreSQLDialect.INSTANCE.markForTableNameAndColumnName()){
            columnName = "\"" + columnName + "\"";
        }
        part.append(" ").append(columnName).append(" timestamp without time zone");
        withNullable(part,bean);
        withDefault(part,bean,"::timestamp");
        builder.add(part.toString());
        return part.toString();
    }

  
    @Override
    public DATA_SOURCE_TYPE getDataSourceType() {
        // TODO Auto-generated method stub
        return DATA_SOURCE_TYPE.postgreSQL;
    }

 
 
  
  

}
