package com.northpool.resources.sql.jdbc;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.LinkedHashMap;
import java.util.Map;

import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.IResourcesDataOutput;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.resources.sql.ResultSetMapping;
import com.northpool.type.Type;

public class ArrayJDBCTransformer extends AbstractsJDBCTransformer<Object[]> implements IJDBCTransformer<Object[]>{

	@Override
	protected ResultSetMapping<Object[],ResultSet> getMapping() {
		
		return new ResultSetMapping<Object[],ResultSet>(){
			
			@Override
			public Object[] mapping(ResultSet rs, LinkedHashMap<String, Type> typeMap,final IDialect dialect) {
				// TODO Auto-generated method stub
				ResultSetMetaData rsmd;
				int systemFiledNum = 0;
				try {
					rsmd = rs.getMetaData();
					int columnCount = rsmd.getColumnCount();
					Object[] values = new Object[columnCount];
					for (int i = 1; i <= columnCount; i++) {
						String name = rsmd.getColumnLabel(i);
						if(dialect.isSystemMarkFiled(name)){
						    systemFiledNum++;
						    continue;
						}
						Type type = typeMap.get(name);
						Object value = null;
						IResourcesDataOutput<ResultSet,Integer> output = dialect.getResourcesDataOutput();
						value = output.output(rs, type, i);
						values[i - 1 - systemFiledNum] = value;
					}
					if(systemFiledNum == 0){
					    return values;
					}else{
					    Object[] valuesNew = new Object[columnCount - systemFiledNum];
					    System.arraycopy(values, 0, valuesNew, 0, columnCount - systemFiledNum);
					    return valuesNew;
					}
				} catch (Exception e) {
					e.printStackTrace();
					throw new RuntimeException(e);
				}
			}
			
		};
	}


  
	
	
	
	
	
}
