/**
　 * <p>Title: Transaction.java</p>
　 * <p>Description: </p>
　 * <p>Copyright: Copyright (c) 2019</p>
　 * <p>Company: northpool</p>
　 * @author matt
　 * @date 2020年11月4日
　 * @version 1.0
*/
package com.northpool.resources.sql.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;

import javax.sql.DataSource;


import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datasource.db.JDBCPoolManager;

/**
 * @author matt
 * 只能保证一个数据库,在同一个线程的事务
 */
public class Transactions {
    
   // static final InheritableThreadLocal<HashMap<String,SingleConnectionDataSource>> SINGLE_CONNECTION_IN_THREAD = new InheritableThreadLocal<>();
    static final ThreadLocal<HashMap<String,SingleConnectionDataSource>> SINGLE_CONNECTION_IN_THREAD = new ThreadLocal<>();
        
    public static void begin(DbDataSource dbDataSource) throws SQLException{
        SingleConnectionDataSource dataSource = _useSingleConnectionInThread(dbDataSource);
        dataSource.getConnection().setAutoCommit(false);
  
        dataSource.isTransactionActive = true;
        
    }
    
    public static boolean isTransactionActive(DbDataSource dbDataSource){
        DataSource dataSource = getThreadDataSource(dbDataSource);
        if(dataSource == null){
            return false;
        }
        SingleConnectionDataSource sds = (SingleConnectionDataSource)dataSource;
        return sds.isTransactionActive();
    }
    
    public static void commit(DbDataSource dbDataSource)  throws SQLException{
        DataSource dataSource = getThreadDataSource(dbDataSource);
        try {
            dataSource.getConnection().commit();
        } catch (SQLException e) {
            // TODO Auto-generated catch block
            throw e;
        } finally {
            dataSource.getConnection().setAutoCommit(true);
       //     dataSource.getConnection().setTransactionIsolation(Connection.TRANSACTION_NONE);
            SingleConnectionDataSource sds = (SingleConnectionDataSource)dataSource;
            sds.isTransactionActive = false;
            connectionInThreadRelease(dbDataSource);
        }
    }
    
    public static void rollback(DbDataSource dbDataSource) throws SQLException{
        DataSource dataSource = getThreadDataSource(dbDataSource);
        try {
            dataSource.getConnection().rollback();
        } catch (SQLException e) {
            // TODO Auto-generated catch block
            throw e;
        } finally {
            dataSource.getConnection().setAutoCommit(true);
            
            SingleConnectionDataSource sds = (SingleConnectionDataSource)dataSource;
            sds.isTransactionActive = false;
            connectionInThreadRelease(dbDataSource);
        }
    }
    
    static SingleConnectionDataSource _useSingleConnectionInThread(DbDataSource dbDataSource){
        HashMap<String,SingleConnectionDataSource> map = SINGLE_CONNECTION_IN_THREAD.get();
        if(map == null){
            map = new HashMap<>();
            SINGLE_CONNECTION_IN_THREAD.set(map);
        }
        DataSource dataSource = JDBCPoolManager.getInstance().getPool(dbDataSource);
        Connection connection;
        try {
            connection = dataSource.getConnection();
        } catch (SQLException e) {
            // TODO Auto-generated catch block
            throw new RuntimeException(e);
        }
        SingleConnectionDataSource data = new SingleConnectionDataSource(connection);
        map.put(dbDataSource.mark(), data);
        return data;
    }
    
    public static void useSingleConnectionInThread(DbDataSource dbDataSource){
        _useSingleConnectionInThread(dbDataSource);
    }
    
   /* public static void setTransactionTimeOut(DbDataSource dbDataSource,long timeOut){
        DataSource dataSource = getThreadDataSource(dbDataSource);
        if(dataSource == null){
            throw 
        }
        
    }*/
    
    public static void connectionInThreadRelease(DbDataSource dbDataSource){
        HashMap<String,SingleConnectionDataSource> map = SINGLE_CONNECTION_IN_THREAD.get();
        if(map == null){
            return;
        }
        DataSource dataSource = map.get(dbDataSource.mark());
        if(dataSource == null){
            return;
        }
        if(dataSource != null){
            try {
                dataSource.getConnection().close();
            } catch (SQLException e) {
                // TODO Auto-generated catch block
                e.printStackTrace();
                //throw new RuntimeException(e);
            } finally {
                map.remove(dbDataSource.mark());
            }
        }
    }
    
    static DataSource getThreadDataSource(DbDataSource dbDataSource){
        HashMap<String,SingleConnectionDataSource> map = SINGLE_CONNECTION_IN_THREAD.get();
        if(map == null){
            return null;
        }
        DataSource dataSource = map.get(dbDataSource.mark());
        return dataSource;
        
        
        
        /*else{
            try {
                Connection connection = dataSource.getConnection();
                dataSource = new SingleConnectionDataSource(connection);
                return dataSource;
            } catch (SQLException e) {
                throw new RuntimeException(e);
            }
        }*/
    }
    
    
}
