/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.datasource.db.operate;

import com.northpool.resources.Constants;
import com.northpool.resources.datasource.IDataSourceOperator;
import com.northpool.resources.datasource.db.DbDataSource;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.operate.ColumnBean;
import com.northpool.resources.datatable.operate.FieldDefaultValueBean;
import com.northpool.resources.datatable.operate.TableSchemaBean;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.sql.DataSource;

public abstract class AbstractDBDataSourceOperator
implements IDataSourceOperator<DbDataSource> {
    public abstract String getSchemaWhenGetTables(DbDataSource var1);

    public abstract String getTableName(String var1, String var2);

    public String[] tables(DbDataSource pool) {
        String schema = this.getSchemaWhenGetTables(pool);
        DataSource datasource = pool.connection();
        Connection connection = null;
        ResultSet ts = null;
        try {
            ArrayList<String> list = new ArrayList<String>();
            connection = datasource.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            ts = databaseMetaData.getTables(null, schema, null, new String[]{"TABLE"});
            while (ts.next()) {
                String tableName = ts.getString("TABLE_NAME");
                list.add(tableName);
            }
            String[] stringArray = list.toArray(new String[list.size()]);
            return stringArray;
        }
        catch (SQLException e) {
            throw new DataAccessException((Exception)e);
        }
        finally {
            try {
                ts.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public void drop(DbDataSource pool, String tableName) {
        ISQLDialect dialect = (ISQLDialect)IDialect.getByType((Constants.DATA_SOURCE_TYPE)pool.getDataSourceType());
        if (dialect.markForTableNameAndColumnName().booleanValue()) {
            tableName = "\"" + tableName + "\"";
        }
        String sql = "drop table " + tableName;
        pool.genericDao().doExecuteSql(sql, null, null);
    }

    public void createTableBySchemaBean(DbDataSource pool, TableSchemaBean tableSchemaBean) {
        String[] sqlArray;
        ISQLDialect dialect = (ISQLDialect)IDialect.getByType((Constants.DATA_SOURCE_TYPE)pool.getDataSourceType());
        tableSchemaBean.getColumnMap().forEach((fieldName, columnBean) -> {
            FieldDefaultValueBean fieldDefaultValue = columnBean.getFieldDefaultValue();
            if (fieldDefaultValue != null && fieldDefaultValue.getType() == FieldDefaultValueBean.VALUE_TYPE.sequence) {
                String sequenceNameRoot = dialect.createSequenceName(tableSchemaBean.getSchema(), tableSchemaBean.getTableName(), fieldName);
                int i = 0;
                String sequenceName = sequenceNameRoot;
                while (this.hasSequence(pool, sequenceNameRoot).booleanValue()) {
                    sequenceName = sequenceNameRoot + "_" + i;
                    ++i;
                }
                this.createSequence(pool, sequenceName);
                fieldDefaultValue.setSequenceName(sequenceName);
            }
        });
        for (String sql : sqlArray = dialect.getCreateTableSQLS(tableSchemaBean)) {
            pool.genericDao().doExecuteSql(sql);
        }
        Optional<Map.Entry> optional = tableSchemaBean.getColumnMap().entrySet().stream().filter(entry -> ((ColumnBean)entry.getValue()).getIsPK()).findFirst();
        String pkColumnName = null;
        if (optional.isPresent()) {
            pkColumnName = ((ColumnBean)optional.get().getValue()).getColumnName();
        }
        if (pkColumnName != null) {
            try {
                pool.getTableOperator(tableSchemaBean.getTableName()).createPK(pkColumnName);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new DataAccessException(e);
            }
        }
    }

    Boolean hasSequence(DbDataSource pool, String sequenceName) {
        ISQLDialect dialect = (ISQLDialect)IDialect.getByType((Constants.DATA_SOURCE_TYPE)pool.getDataSourceType());
        String sql = dialect.hasSequenceSql(sequenceName);
        List<Map<String, Object>> i = pool.genericDao().queryBySql(sql, new Object[]{sequenceName});
        if (i.isEmpty()) {
            return false;
        }
        return true;
    }

    void createSequence(DbDataSource pool, String sequenceName) {
        ISQLDialect dialect = (ISQLDialect)IDialect.getByType((Constants.DATA_SOURCE_TYPE)pool.getDataSourceType());
        String sql = dialect.getCreateSequenceSQL(sequenceName);
        pool.genericDao().doExecuteSql(sql);
    }

    public void createTableIndexBySchemaBean(DbDataSource pool, TableSchemaBean tableSchemaBean) {
        Map indexMap = tableSchemaBean.getIndexMap();
    }

    public List<String> schemas(DbDataSource pool) {
        DataSource dataSource = pool.connection();
        Connection connection = null;
        ResultSet set = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            set = databaseMetaData.getSchemas();
            ArrayList<String> schemas = new ArrayList<String>();
            while (set.next()) {
                schemas.add(set.getString("TABLE_SCHEM"));
            }
            ArrayList<String> arrayList = schemas;
            return arrayList;
        }
        catch (SQLException e) {
            throw new DataAccessException((Exception)e);
        }
        finally {
            try {
                set.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    public Boolean hasSchema(DbDataSource pool, String schema) {
        return true;
    }

    public Boolean hasTable(DbDataSource pool, String tableName) {
        String[] arr = tableName.split("\\.");
        String schema = null;
        if (arr.length > 1) {
            schema = arr[0];
            tableName = arr[1];
        } else {
            ISQLDialect dialect = (ISQLDialect)IDialect.getByType((Constants.DATA_SOURCE_TYPE)pool.getDataSourceType());
            schema = dialect.getDefaultSchema();
        }
        DataSource dataSource = pool.connection();
        Connection connection = null;
        ResultSet set = null;
        try {
            connection = dataSource.getConnection();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            set = databaseMetaData.getTables(null, schema, tableName, new String[]{"TABLE"});
            Boolean bl = set.first();
            return bl;
        }
        catch (SQLException e) {
            throw new DataAccessException((Exception)e);
        }
        finally {
            try {
                set.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            try {
                connection.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }
}

