/*
 * Decompiled with CFR 0.152.
 */
package com.northpool.resources.sql.jdbc;

import com.northpool.exception.UException;
import com.northpool.resources.datatable.dao.DataAccessException;
import com.northpool.resources.datatable.dao.IScroll;
import com.northpool.resources.dialect.IDialect;
import com.northpool.resources.dialect.sql.ISQLDialect;
import com.northpool.resources.sql.ResultSetMapping;
import com.northpool.resources.sql.jdbc.AbstractsJDBCCell;
import com.northpool.resources.sql.jdbc.JDBCScrollStatement;
import com.northpool.type.Type;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractsJDBCTransformer<T> {
    protected LinkedHashMap<String, Type> createTypeMap(ResultSet rs, Map<String, Type> typeMap, IDialect dialect) throws DataAccessException {
        try {
            ResultSetMetaData rsmd = rs.getMetaData();
            int columnCount = rsmd.getColumnCount();
            if (typeMap == null) {
                typeMap = new HashMap<String, Type>();
            }
            LinkedHashMap<String, Type> newTypeMap = new LinkedHashMap<String, Type>();
            for (int i = 1; i <= columnCount; ++i) {
                String typeName = rsmd.getColumnTypeName(i);
                String name = rsmd.getColumnLabel(i);
                Type type = typeMap.get(typeName);
                if (type == null) {
                    type = dialect.getTypeByName(typeName);
                }
                newTypeMap.put(name, type);
            }
            return newTypeMap;
        }
        catch (SQLException e) {
            UException.printStackTrace((Throwable)e);
            throw new DataAccessException((Exception)e);
        }
    }

    protected abstract ResultSetMapping<T, ResultSet> getMapping();

    public List<T> extractData(ISQLDialect dialect, ResultSet rs, Map<String, Type> typeMap) throws DataAccessException {
        try {
            ArrayList<Object> iList = new ArrayList<Object>();
            ResultSetMapping<T, ResultSet> mapping = this.getMapping();
            LinkedHashMap<String, Type> newTypeMap = this.createTypeMap(rs, typeMap, (IDialect)dialect);
            while (rs.next()) {
                Object t = mapping.mapping((Object)rs, newTypeMap, (IDialect)dialect);
                iList.add(t);
            }
            return iList;
        }
        catch (SQLException e) {
            UException.printStackTrace((Throwable)e);
            throw new DataAccessException((Exception)e);
        }
    }

    public IScroll<T> extractDataScroll(final ISQLDialect dialect, final ResultSet rs, Map<String, Type> typeMap, final JDBCScrollStatement scrollStatement) throws DataAccessException {
        final ResultSetMapping<T, ResultSet> mapping = this.getMapping();
        final LinkedHashMap<String, Type> newTypeMap = this.createTypeMap(rs, typeMap, (IDialect)dialect);
        IScroll scroll = new IScroll<T>(){

            public boolean hasNext() {
                try {
                    return rs.next();
                }
                catch (SQLException e) {
                    UException.printStackTrace((Throwable)e);
                    throw new DataAccessException((Exception)e);
                }
            }

            public T next() {
                Object t = mapping.mapping((Object)rs, newTypeMap, (IDialect)dialect);
                return t;
            }

            public void close() throws IOException {
                AbstractsJDBCCell.closeStatement(scrollStatement.getPs());
                AbstractsJDBCCell.releaseConnection(scrollStatement.getCon(), scrollStatement.getDbDataSource());
            }
        };
        return scroll;
    }
}

