package com.northpool.resources.datasource.db;





import com.northpool.resources.Constants.DATA_SOURCE_TYPE;
import com.northpool.resources.datasource.ADataSource;
import com.northpool.resources.datasource.AbstractDataSource;
import com.northpool.resources.datasource.IDataSource;
import com.northpool.resources.datasource.PasswordCrypo;
import com.northpool.resources.sql.jdbc.IJDBCGenericDao;
import com.northpool.resources.sql.jdbc.JDBCGenericDaoImpl;

import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

/**
 * 
 * 
 * @author matt
 *
 */ 
@ADataSource(name = "db" ,types = "oracle,postgreSQL,kingbase,highgo,mysql,mysql8.0")
public class DbDataSource extends AbstractDataSource implements IDataSource {
	
	/**
	 * url地址
	 */
	protected String url;
	/**
	 * 账号
	 */
	protected String user;
	/**
	 * 密码
	 */
	@Deprecated
	protected String password;
	 
	/**
	 * 加密密码
	 */
	protected String crypoPassword;
	
	

	protected Connection dbconn = null;

	protected String poolName = DBPoolParameter.DEFAULT_POOL_NAME;
	
	
	
	 
	    /**
	     * 序列化专用，禁止使用本方法初始化
	     */
    DbDataSource(){
		
	}
	
	public DbDataSource(String id,String url,String user,String password,DATA_SOURCE_TYPE dataSourceType){
		this.id = id;
		this.url = url;
		this.user = user;
	//	this.password = password;
		if(password != null){
        	this.crypoPassword = PasswordCrypo.encode(password);
        }
		this.dataSourceType = dataSourceType;
		/*if(this.id == null){
		    this.id = this.toString();
		}*/
	}
	
	public String getCrypoPassword() {
		return crypoPassword;
	}

	public void setCrypoPassword(String crypoPassword) {
		this.crypoPassword = crypoPassword;
	}

	public DbDataSource(String url,String user,String password,DATA_SOURCE_TYPE dataSourceType){
        this.url = url;
        this.user = user;
      //  this.password = password;
        if(password != null){
        	this.crypoPassword = PasswordCrypo.encode(password);
        }
        this.dataSourceType = dataSourceType;
      /*  if(this.id == null){
            this.id = this.toString();
        }*/
    }
	


	public String getUrl() {
		return url;
	}

	
	public String getId() {
        return id == null ? this.mark() : this.id;
    }
	
	

	public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }
    @Deprecated
    public void setPassword(String password) {
        this.password = password;
    }

    public String getUser() {
		return user;
	}

	public Connection getDbconn() {
		return dbconn;
	}

	public void setDbconn(Connection dbconn) {
		this.dbconn = dbconn;
	}

	@Deprecated
	public String getPassword() {
		return password;
	}

	
	public String toString(){
	    return this.mark();
	}
	
	@Override
	public String mark() {
		if(crypoPassword != null){
			return  new StringBuilder().append(this.dataSourceType.name()).append('_').append(this.processURL(this.url)).append('_').append(this.user).append("_").append(this.crypoPassword).toString();
	
		}else{
			return  new StringBuilder().append(this.dataSourceType.name()).append('_').append(this.processURL(this.url)).append('_').append(this.user).toString();
		}
	}
	
	protected String processURL(String url){
		url = url.replaceAll("\\/", "@");
		return url;
	}
	
	protected String password(){
		if(this.password != null){
			return this.password;
		}else{
			return PasswordCrypo.decode(crypoPassword);
		}
	}
	

	/**
	 * 创建新连接池
	 * @param poolName
	 * @return
	 */
	public DbDataSource getDbDataSourcePool(String poolName){
	    DbDataSource dbDataSource = new DbDataSource( this.id,this.url,this.user,this.password(),this.dataSourceType);
	    dbDataSource.poolName = poolName;
	    return dbDataSource;
	}
	
	

	
	

	
	
	//public DataSource dataSource = JDBCPoolManager.getInstance().getDataSourcePool(dbDataSource.getDataSourceType(), dbDataSource.get, user, password, other);
	@SuppressWarnings("unchecked")
	@Override
	public javax.sql.DataSource connection() {
		javax.sql.DataSource dataSource = JDBCPoolManager.getInstance().getPool(this);
		return dataSource;
	}
	
	@Override
	public synchronized void resetConnection() {
		JDBCPoolManager.getInstance().remove(this.dataSourceType, url, user,this.password());
	}
	
	@Override
	public synchronized void destory(){
		JDBCPoolManager.getInstance().remove(this.dataSourceType, url, user,this.password());
	}
	
	public IJDBCGenericDao genericDao() {
		return new JDBCGenericDaoImpl(this);
	}


	@Deprecated
	@Override
	public ResultSet getSqlQuery(String sql) {
	    Statement statement = null;
	    try {
			if (this.dbconn == null) {
				this.dbconn = this.connection().getConnection();
			}
			statement = dbconn.createStatement();
			ResultSet resultSet = statement.executeQuery(sql);
			if(resultSet.wasNull()){
				throw new RuntimeException( "获取表集合失败");
			}
			
			return resultSet;
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
            if (statement != null) {
                try {
                    statement.close();
                    this.dbconn.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
		return null;
	}

	@Deprecated
	@Override
	public Boolean executeSqlCommand(String sql) {
	    Statement statement = null;
	    try {
			if (this.dbconn == null) {
				this.dbconn = this.connection().getConnection();
			}
			statement = dbconn.createStatement();
			boolean execute = statement.execute(sql);
			return execute;
		} catch (SQLException e) {
			e.printStackTrace();
		} finally {
		    if (statement != null) {
                try {
                    statement.close();
                    this.dbconn.close();
                } catch (SQLException e) {
                    e.printStackTrace();
                }
            }
        }
		return false;
	}
	
	
	
	
	

	@Override
	public void testConnection() throws Exception {
		// TODO Auto-generated method stub
		JDBCPoolManager.getInstance().inValid(this.dataSourceType, url, user, password());
	}


	@Override
	public boolean equals(Object o) {
		if (this == o) {
		    return true;
		}

		if (o == null || getClass() != o.getClass()) {
		    return false;
		}

		DbDataSource that = (DbDataSource) o;

		return new EqualsBuilder()
				.append(url, that.url)
				.append(user, that.user)
				.append(password(), that.password())
				.append(dataSourceType, that.dataSourceType)
				.isEquals();
	}

	@Override
	public int hashCode() {
		return new HashCodeBuilder(17, 37)
				.append(url)
				.append(user)
				.append(password())
				.append(dataSourceType)
				.toHashCode();
	}


	public String getVersion() {
		return version;
	}

	public void setVersion(String version) {
		this.version = version;
	}
	
	
}
